/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.config.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Evaluation JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class EvaluationUnmarshaller implements Unmarshaller<Evaluation, JsonUnmarshallerContext> {

    public Evaluation unmarshall(JsonUnmarshallerContext context) throws Exception {
        Evaluation.Builder evaluationBuilder = Evaluation.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("ComplianceResourceType", targetDepth)) {
                    context.nextToken();
                    evaluationBuilder.complianceResourceType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ComplianceResourceId", targetDepth)) {
                    context.nextToken();
                    evaluationBuilder.complianceResourceId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ComplianceType", targetDepth)) {
                    context.nextToken();
                    evaluationBuilder.complianceType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Annotation", targetDepth)) {
                    context.nextToken();
                    evaluationBuilder.annotation(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("OrderingTimestamp", targetDepth)) {
                    context.nextToken();
                    evaluationBuilder.orderingTimestamp(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return evaluationBuilder.build();
    }

    private static final EvaluationUnmarshaller INSTANCE = new EvaluationUnmarshaller();

    public static EvaluationUnmarshaller getInstance() {
        return INSTANCE;
    }
}
