/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link GetAggregateComplianceDetailsByConfigRuleRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class GetAggregateComplianceDetailsByConfigRuleRequestModelMarshaller {
    private static final MarshallingInfo<String> CONFIGURATIONAGGREGATORNAME_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ConfigurationAggregatorName").isBinary(false).build();

    private static final MarshallingInfo<String> CONFIGRULENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigRuleName").isBinary(false).build();

    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountId").isBinary(false).build();

    private static final MarshallingInfo<String> AWSREGION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AwsRegion").isBinary(false).build();

    private static final MarshallingInfo<String> COMPLIANCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceType").isBinary(false).build();

    private static final MarshallingInfo<Integer> LIMIT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Limit").isBinary(false).build();

    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();

    private static final GetAggregateComplianceDetailsByConfigRuleRequestModelMarshaller INSTANCE = new GetAggregateComplianceDetailsByConfigRuleRequestModelMarshaller();

    private GetAggregateComplianceDetailsByConfigRuleRequestModelMarshaller() {
    }

    public static GetAggregateComplianceDetailsByConfigRuleRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(GetAggregateComplianceDetailsByConfigRuleRequest getAggregateComplianceDetailsByConfigRuleRequest,
            ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(getAggregateComplianceDetailsByConfigRuleRequest,
                "getAggregateComplianceDetailsByConfigRuleRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(getAggregateComplianceDetailsByConfigRuleRequest.configurationAggregatorName(),
                    CONFIGURATIONAGGREGATORNAME_BINDING);
            protocolMarshaller
                    .marshall(getAggregateComplianceDetailsByConfigRuleRequest.configRuleName(), CONFIGRULENAME_BINDING);
            protocolMarshaller.marshall(getAggregateComplianceDetailsByConfigRuleRequest.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall(getAggregateComplianceDetailsByConfigRuleRequest.awsRegion(), AWSREGION_BINDING);
            protocolMarshaller.marshall(getAggregateComplianceDetailsByConfigRuleRequest.complianceTypeAsString(),
                    COMPLIANCETYPE_BINDING);
            protocolMarshaller.marshall(getAggregateComplianceDetailsByConfigRuleRequest.limit(), LIMIT_BINDING);
            protocolMarshaller.marshall(getAggregateComplianceDetailsByConfigRuleRequest.nextToken(), NEXTTOKEN_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
