/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link GetResourceConfigHistoryRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class GetResourceConfigHistoryRequestModelMarshaller {
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").isBinary(false).build();

    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceId").isBinary(false).build();

    private static final MarshallingInfo<Instant> LATERTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("laterTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> EARLIERTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("earlierTime").isBinary(false).build();

    private static final MarshallingInfo<String> CHRONOLOGICALORDER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("chronologicalOrder").isBinary(false).build();

    private static final MarshallingInfo<Integer> LIMIT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("limit").isBinary(false).build();

    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nextToken").isBinary(false).build();

    private static final GetResourceConfigHistoryRequestModelMarshaller INSTANCE = new GetResourceConfigHistoryRequestModelMarshaller();

    private GetResourceConfigHistoryRequestModelMarshaller() {
    }

    public static GetResourceConfigHistoryRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(GetResourceConfigHistoryRequest getResourceConfigHistoryRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(getResourceConfigHistoryRequest, "getResourceConfigHistoryRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(getResourceConfigHistoryRequest.resourceTypeAsString(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall(getResourceConfigHistoryRequest.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall(getResourceConfigHistoryRequest.laterTime(), LATERTIME_BINDING);
            protocolMarshaller.marshall(getResourceConfigHistoryRequest.earlierTime(), EARLIERTIME_BINDING);
            protocolMarshaller.marshall(getResourceConfigHistoryRequest.chronologicalOrderAsString(), CHRONOLOGICALORDER_BINDING);
            protocolMarshaller.marshall(getResourceConfigHistoryRequest.limit(), LIMIT_BINDING);
            protocolMarshaller.marshall(getResourceConfigHistoryRequest.nextToken(), NEXTTOKEN_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
