/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ListDiscoveredResourcesRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ListDiscoveredResourcesRequestModelMarshaller {
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").isBinary(false).build();

    private static final MarshallingInfo<List> RESOURCEIDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceIds").isBinary(false).build();

    private static final MarshallingInfo<String> RESOURCENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceName").isBinary(false).build();

    private static final MarshallingInfo<Integer> LIMIT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("limit").isBinary(false).build();

    private static final MarshallingInfo<Boolean> INCLUDEDELETEDRESOURCES_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("includeDeletedResources").isBinary(false).build();

    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nextToken").isBinary(false).build();

    private static final ListDiscoveredResourcesRequestModelMarshaller INSTANCE = new ListDiscoveredResourcesRequestModelMarshaller();

    private ListDiscoveredResourcesRequestModelMarshaller() {
    }

    public static ListDiscoveredResourcesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ListDiscoveredResourcesRequest listDiscoveredResourcesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(listDiscoveredResourcesRequest, "listDiscoveredResourcesRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(listDiscoveredResourcesRequest.resourceTypeAsString(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall(listDiscoveredResourcesRequest.resourceIds(), RESOURCEIDS_BINDING);
            protocolMarshaller.marshall(listDiscoveredResourcesRequest.resourceName(), RESOURCENAME_BINDING);
            protocolMarshaller.marshall(listDiscoveredResourcesRequest.limit(), LIMIT_BINDING);
            protocolMarshaller
                    .marshall(listDiscoveredResourcesRequest.includeDeletedResources(), INCLUDEDELETEDRESOURCES_BINDING);
            protocolMarshaller.marshall(listDiscoveredResourcesRequest.nextToken(), NEXTTOKEN_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
