/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.Scope;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link Scope} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ScopeMarshaller {
    private static final MarshallingInfo<List> COMPLIANCERESOURCETYPES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceResourceTypes").isBinary(false).build();

    private static final MarshallingInfo<String> TAGKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TagKey").isBinary(false).build();

    private static final MarshallingInfo<String> TAGVALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TagValue").isBinary(false).build();

    private static final MarshallingInfo<String> COMPLIANCERESOURCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceResourceId").isBinary(false).build();

    private static final ScopeMarshaller INSTANCE = new ScopeMarshaller();

    private ScopeMarshaller() {
    }

    public static ScopeMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(Scope scope, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(scope, "scope");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(scope.complianceResourceTypes(), COMPLIANCERESOURCETYPES_BINDING);
            protocolMarshaller.marshall(scope.tagKey(), TAGKEY_BINDING);
            protocolMarshaller.marshall(scope.tagValue(), TAGVALUE_BINDING);
            protocolMarshaller.marshall(scope.complianceResourceId(), COMPLIANCERESOURCEID_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
