/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.model.BatchGetResourceConfigRequest;
import software.amazon.awssdk.services.config.model.BatchGetResourceConfigResponse;
import software.amazon.awssdk.services.config.model.ConfigException;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationRequest;
import software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigurationAggregatorRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigurationAggregatorResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.DeleteDeliveryChannelRequest;
import software.amazon.awssdk.services.config.model.DeleteDeliveryChannelResponse;
import software.amazon.awssdk.services.config.model.DeleteEvaluationResultsRequest;
import software.amazon.awssdk.services.config.model.DeleteEvaluationResultsResponse;
import software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestRequest;
import software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestResponse;
import software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationRequest;
import software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationResponse;
import software.amazon.awssdk.services.config.model.DeliverConfigSnapshotRequest;
import software.amazon.awssdk.services.config.model.DeliverConfigSnapshotResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersResponse;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsRequest;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsResponse;
import software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest;
import software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse;
import software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest;
import software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse;
import software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceResponse;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeRequest;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeResponse;
import software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest;
import software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse;
import software.amazon.awssdk.services.config.model.InsufficientDeliveryPolicyException;
import software.amazon.awssdk.services.config.model.InsufficientPermissionsException;
import software.amazon.awssdk.services.config.model.InvalidConfigurationRecorderNameException;
import software.amazon.awssdk.services.config.model.InvalidDeliveryChannelNameException;
import software.amazon.awssdk.services.config.model.InvalidLimitException;
import software.amazon.awssdk.services.config.model.InvalidNextTokenException;
import software.amazon.awssdk.services.config.model.InvalidParameterValueException;
import software.amazon.awssdk.services.config.model.InvalidRecordingGroupException;
import software.amazon.awssdk.services.config.model.InvalidResultTokenException;
import software.amazon.awssdk.services.config.model.InvalidRoleException;
import software.amazon.awssdk.services.config.model.InvalidS3KeyPrefixException;
import software.amazon.awssdk.services.config.model.InvalidSnsTopicArnException;
import software.amazon.awssdk.services.config.model.InvalidTimeRangeException;
import software.amazon.awssdk.services.config.model.LastDeliveryChannelDeleteFailedException;
import software.amazon.awssdk.services.config.model.LimitExceededException;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesResponse;
import software.amazon.awssdk.services.config.model.MaxNumberOfConfigRulesExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfConfigurationRecordersExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfDeliveryChannelsExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfRetentionConfigurationsExceededException;
import software.amazon.awssdk.services.config.model.NoAvailableConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoAvailableDeliveryChannelException;
import software.amazon.awssdk.services.config.model.NoAvailableOrganizationException;
import software.amazon.awssdk.services.config.model.NoRunningConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoSuchBucketException;
import software.amazon.awssdk.services.config.model.NoSuchConfigRuleException;
import software.amazon.awssdk.services.config.model.NoSuchConfigurationAggregatorException;
import software.amazon.awssdk.services.config.model.NoSuchConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoSuchDeliveryChannelException;
import software.amazon.awssdk.services.config.model.NoSuchRetentionConfigurationException;
import software.amazon.awssdk.services.config.model.OrganizationAccessDeniedException;
import software.amazon.awssdk.services.config.model.OrganizationAllFeaturesNotEnabledException;
import software.amazon.awssdk.services.config.model.PutAggregationAuthorizationRequest;
import software.amazon.awssdk.services.config.model.PutAggregationAuthorizationResponse;
import software.amazon.awssdk.services.config.model.PutConfigRuleRequest;
import software.amazon.awssdk.services.config.model.PutConfigRuleResponse;
import software.amazon.awssdk.services.config.model.PutConfigurationAggregatorRequest;
import software.amazon.awssdk.services.config.model.PutConfigurationAggregatorResponse;
import software.amazon.awssdk.services.config.model.PutConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.PutConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.PutDeliveryChannelRequest;
import software.amazon.awssdk.services.config.model.PutDeliveryChannelResponse;
import software.amazon.awssdk.services.config.model.PutEvaluationsRequest;
import software.amazon.awssdk.services.config.model.PutEvaluationsResponse;
import software.amazon.awssdk.services.config.model.PutRetentionConfigurationRequest;
import software.amazon.awssdk.services.config.model.PutRetentionConfigurationResponse;
import software.amazon.awssdk.services.config.model.ResourceInUseException;
import software.amazon.awssdk.services.config.model.ResourceNotDiscoveredException;
import software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationRequest;
import software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationResponse;
import software.amazon.awssdk.services.config.model.StartConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.StartConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.StopConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.StopConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.ValidationException;
import software.amazon.awssdk.services.config.paginators.GetResourceConfigHistoryIterable;
import software.amazon.awssdk.services.config.transform.BatchGetResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.BatchGetResourceConfigResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DeleteAggregationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteAggregationAuthorizationResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigRuleResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigurationAggregatorRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigurationAggregatorResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigurationRecorderResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DeleteDeliveryChannelRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteDeliveryChannelResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DeleteEvaluationResultsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteEvaluationResultsResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DeletePendingAggregationRequestRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeletePendingAggregationRequestResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DeleteRetentionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteRetentionConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DeliverConfigSnapshotRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeliverConfigSnapshotResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DescribeAggregateComplianceByConfigRulesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeAggregateComplianceByConfigRulesResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DescribeAggregationAuthorizationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeAggregationAuthorizationsResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DescribeComplianceByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeComplianceByConfigRuleResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DescribeComplianceByResourceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeComplianceByResourceResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigRuleEvaluationStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigRuleEvaluationStatusResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigRulesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigRulesResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationAggregatorSourcesStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationAggregatorSourcesStatusResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationAggregatorsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationAggregatorsResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationRecorderStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationRecorderStatusResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationRecordersRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationRecordersResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DescribeDeliveryChannelStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeDeliveryChannelStatusResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DescribeDeliveryChannelsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeDeliveryChannelsResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DescribePendingAggregationRequestsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribePendingAggregationRequestsResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DescribeRetentionConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeRetentionConfigurationsResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateComplianceDetailsByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateComplianceDetailsByConfigRuleResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateConfigRuleComplianceSummaryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateConfigRuleComplianceSummaryResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceDetailsByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceDetailsByConfigRuleResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceDetailsByResourceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceDetailsByResourceResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceSummaryByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceSummaryByConfigRuleResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceSummaryByResourceTypeRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceSummaryByResourceTypeResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.GetDiscoveredResourceCountsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetDiscoveredResourceCountsResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.GetResourceConfigHistoryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetResourceConfigHistoryResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.ListDiscoveredResourcesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListDiscoveredResourcesResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.PutAggregationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutAggregationAuthorizationResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigRuleResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigurationAggregatorRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigurationAggregatorResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigurationRecorderResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.PutDeliveryChannelRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutDeliveryChannelResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.PutEvaluationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutEvaluationsResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.PutRetentionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutRetentionConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.StartConfigRulesEvaluationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StartConfigRulesEvaluationResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.StartConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StartConfigurationRecorderResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.StopConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StopConfigurationRecorderResponseUnmarshaller;

@SdkInternalApi
final class DefaultConfigClient
implements ConfigClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultConfigClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(false);
    }

    public final String serviceName() {
        return "config";
    }

    @Override
    public BatchGetResourceConfigResponse batchGetResourceConfig(BatchGetResourceConfigRequest batchGetResourceConfigRequest) throws ValidationException, NoAvailableConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchGetResourceConfigResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (BatchGetResourceConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchGetResourceConfigRequest).withMarshaller((Marshaller)new BatchGetResourceConfigRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteAggregationAuthorizationResponse deleteAggregationAuthorization(DeleteAggregationAuthorizationRequest deleteAggregationAuthorizationRequest) throws InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAggregationAuthorizationResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteAggregationAuthorizationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAggregationAuthorizationRequest).withMarshaller((Marshaller)new DeleteAggregationAuthorizationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteConfigRuleResponse deleteConfigRule(DeleteConfigRuleRequest deleteConfigRuleRequest) throws NoSuchConfigRuleException, ResourceInUseException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteConfigRuleResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteConfigRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConfigRuleRequest).withMarshaller((Marshaller)new DeleteConfigRuleRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteConfigurationAggregatorResponse deleteConfigurationAggregator(DeleteConfigurationAggregatorRequest deleteConfigurationAggregatorRequest) throws NoSuchConfigurationAggregatorException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteConfigurationAggregatorResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteConfigurationAggregatorResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConfigurationAggregatorRequest).withMarshaller((Marshaller)new DeleteConfigurationAggregatorRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteConfigurationRecorderResponse deleteConfigurationRecorder(DeleteConfigurationRecorderRequest deleteConfigurationRecorderRequest) throws NoSuchConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteConfigurationRecorderResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteConfigurationRecorderResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConfigurationRecorderRequest).withMarshaller((Marshaller)new DeleteConfigurationRecorderRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteDeliveryChannelResponse deleteDeliveryChannel(DeleteDeliveryChannelRequest deleteDeliveryChannelRequest) throws NoSuchDeliveryChannelException, LastDeliveryChannelDeleteFailedException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDeliveryChannelResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteDeliveryChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDeliveryChannelRequest).withMarshaller((Marshaller)new DeleteDeliveryChannelRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteEvaluationResultsResponse deleteEvaluationResults(DeleteEvaluationResultsRequest deleteEvaluationResultsRequest) throws NoSuchConfigRuleException, ResourceInUseException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteEvaluationResultsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteEvaluationResultsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEvaluationResultsRequest).withMarshaller((Marshaller)new DeleteEvaluationResultsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeletePendingAggregationRequestResponse deletePendingAggregationRequest(DeletePendingAggregationRequestRequest deletePendingAggregationRequestRequest) throws InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeletePendingAggregationRequestResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeletePendingAggregationRequestResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePendingAggregationRequestRequest).withMarshaller((Marshaller)new DeletePendingAggregationRequestRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteRetentionConfigurationResponse deleteRetentionConfiguration(DeleteRetentionConfigurationRequest deleteRetentionConfigurationRequest) throws InvalidParameterValueException, NoSuchRetentionConfigurationException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteRetentionConfigurationResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteRetentionConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRetentionConfigurationRequest).withMarshaller((Marshaller)new DeleteRetentionConfigurationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeliverConfigSnapshotResponse deliverConfigSnapshot(DeliverConfigSnapshotRequest deliverConfigSnapshotRequest) throws NoSuchDeliveryChannelException, NoAvailableConfigurationRecorderException, NoRunningConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeliverConfigSnapshotResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeliverConfigSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deliverConfigSnapshotRequest).withMarshaller((Marshaller)new DeliverConfigSnapshotRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeAggregateComplianceByConfigRulesResponse describeAggregateComplianceByConfigRules(DescribeAggregateComplianceByConfigRulesRequest describeAggregateComplianceByConfigRulesRequest) throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAggregateComplianceByConfigRulesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeAggregateComplianceByConfigRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAggregateComplianceByConfigRulesRequest).withMarshaller((Marshaller)new DescribeAggregateComplianceByConfigRulesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeAggregationAuthorizationsResponse describeAggregationAuthorizations(DescribeAggregationAuthorizationsRequest describeAggregationAuthorizationsRequest) throws InvalidParameterValueException, InvalidNextTokenException, InvalidLimitException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAggregationAuthorizationsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeAggregationAuthorizationsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAggregationAuthorizationsRequest).withMarshaller((Marshaller)new DescribeAggregationAuthorizationsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeComplianceByConfigRuleResponse describeComplianceByConfigRule(DescribeComplianceByConfigRuleRequest describeComplianceByConfigRuleRequest) throws InvalidParameterValueException, NoSuchConfigRuleException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeComplianceByConfigRuleResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeComplianceByConfigRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeComplianceByConfigRuleRequest).withMarshaller((Marshaller)new DescribeComplianceByConfigRuleRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeComplianceByResourceResponse describeComplianceByResource(DescribeComplianceByResourceRequest describeComplianceByResourceRequest) throws InvalidParameterValueException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeComplianceByResourceResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeComplianceByResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeComplianceByResourceRequest).withMarshaller((Marshaller)new DescribeComplianceByResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeConfigRuleEvaluationStatusResponse describeConfigRuleEvaluationStatus(DescribeConfigRuleEvaluationStatusRequest describeConfigRuleEvaluationStatusRequest) throws NoSuchConfigRuleException, InvalidParameterValueException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeConfigRuleEvaluationStatusResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeConfigRuleEvaluationStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConfigRuleEvaluationStatusRequest).withMarshaller((Marshaller)new DescribeConfigRuleEvaluationStatusRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeConfigRulesResponse describeConfigRules(DescribeConfigRulesRequest describeConfigRulesRequest) throws NoSuchConfigRuleException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeConfigRulesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeConfigRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConfigRulesRequest).withMarshaller((Marshaller)new DescribeConfigRulesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeConfigurationAggregatorSourcesStatusResponse describeConfigurationAggregatorSourcesStatus(DescribeConfigurationAggregatorSourcesStatusRequest describeConfigurationAggregatorSourcesStatusRequest) throws InvalidParameterValueException, NoSuchConfigurationAggregatorException, InvalidNextTokenException, InvalidLimitException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeConfigurationAggregatorSourcesStatusResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeConfigurationAggregatorSourcesStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConfigurationAggregatorSourcesStatusRequest).withMarshaller((Marshaller)new DescribeConfigurationAggregatorSourcesStatusRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeConfigurationAggregatorsResponse describeConfigurationAggregators(DescribeConfigurationAggregatorsRequest describeConfigurationAggregatorsRequest) throws InvalidParameterValueException, NoSuchConfigurationAggregatorException, InvalidNextTokenException, InvalidLimitException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeConfigurationAggregatorsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeConfigurationAggregatorsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConfigurationAggregatorsRequest).withMarshaller((Marshaller)new DescribeConfigurationAggregatorsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeConfigurationRecorderStatusResponse describeConfigurationRecorderStatus(DescribeConfigurationRecorderStatusRequest describeConfigurationRecorderStatusRequest) throws NoSuchConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeConfigurationRecorderStatusResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeConfigurationRecorderStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConfigurationRecorderStatusRequest).withMarshaller((Marshaller)new DescribeConfigurationRecorderStatusRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeConfigurationRecordersResponse describeConfigurationRecorders(DescribeConfigurationRecordersRequest describeConfigurationRecordersRequest) throws NoSuchConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeConfigurationRecordersResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeConfigurationRecordersResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConfigurationRecordersRequest).withMarshaller((Marshaller)new DescribeConfigurationRecordersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDeliveryChannelStatusResponse describeDeliveryChannelStatus(DescribeDeliveryChannelStatusRequest describeDeliveryChannelStatusRequest) throws NoSuchDeliveryChannelException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDeliveryChannelStatusResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeDeliveryChannelStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDeliveryChannelStatusRequest).withMarshaller((Marshaller)new DescribeDeliveryChannelStatusRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDeliveryChannelsResponse describeDeliveryChannels(DescribeDeliveryChannelsRequest describeDeliveryChannelsRequest) throws NoSuchDeliveryChannelException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDeliveryChannelsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeDeliveryChannelsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDeliveryChannelsRequest).withMarshaller((Marshaller)new DescribeDeliveryChannelsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribePendingAggregationRequestsResponse describePendingAggregationRequests(DescribePendingAggregationRequestsRequest describePendingAggregationRequestsRequest) throws InvalidParameterValueException, InvalidNextTokenException, InvalidLimitException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribePendingAggregationRequestsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribePendingAggregationRequestsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePendingAggregationRequestsRequest).withMarshaller((Marshaller)new DescribePendingAggregationRequestsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeRetentionConfigurationsResponse describeRetentionConfigurations(DescribeRetentionConfigurationsRequest describeRetentionConfigurationsRequest) throws InvalidParameterValueException, NoSuchRetentionConfigurationException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeRetentionConfigurationsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeRetentionConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRetentionConfigurationsRequest).withMarshaller((Marshaller)new DescribeRetentionConfigurationsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetAggregateComplianceDetailsByConfigRuleResponse getAggregateComplianceDetailsByConfigRule(GetAggregateComplianceDetailsByConfigRuleRequest getAggregateComplianceDetailsByConfigRuleRequest) throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAggregateComplianceDetailsByConfigRuleResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetAggregateComplianceDetailsByConfigRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAggregateComplianceDetailsByConfigRuleRequest).withMarshaller((Marshaller)new GetAggregateComplianceDetailsByConfigRuleRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetAggregateConfigRuleComplianceSummaryResponse getAggregateConfigRuleComplianceSummary(GetAggregateConfigRuleComplianceSummaryRequest getAggregateConfigRuleComplianceSummaryRequest) throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAggregateConfigRuleComplianceSummaryResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetAggregateConfigRuleComplianceSummaryResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAggregateConfigRuleComplianceSummaryRequest).withMarshaller((Marshaller)new GetAggregateConfigRuleComplianceSummaryRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetComplianceDetailsByConfigRuleResponse getComplianceDetailsByConfigRule(GetComplianceDetailsByConfigRuleRequest getComplianceDetailsByConfigRuleRequest) throws InvalidParameterValueException, InvalidNextTokenException, NoSuchConfigRuleException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetComplianceDetailsByConfigRuleResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetComplianceDetailsByConfigRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getComplianceDetailsByConfigRuleRequest).withMarshaller((Marshaller)new GetComplianceDetailsByConfigRuleRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetComplianceDetailsByResourceResponse getComplianceDetailsByResource(GetComplianceDetailsByResourceRequest getComplianceDetailsByResourceRequest) throws InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetComplianceDetailsByResourceResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetComplianceDetailsByResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getComplianceDetailsByResourceRequest).withMarshaller((Marshaller)new GetComplianceDetailsByResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetComplianceSummaryByConfigRuleResponse getComplianceSummaryByConfigRule(GetComplianceSummaryByConfigRuleRequest getComplianceSummaryByConfigRuleRequest) throws AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetComplianceSummaryByConfigRuleResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetComplianceSummaryByConfigRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getComplianceSummaryByConfigRuleRequest).withMarshaller((Marshaller)new GetComplianceSummaryByConfigRuleRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetComplianceSummaryByResourceTypeResponse getComplianceSummaryByResourceType(GetComplianceSummaryByResourceTypeRequest getComplianceSummaryByResourceTypeRequest) throws InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetComplianceSummaryByResourceTypeResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetComplianceSummaryByResourceTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getComplianceSummaryByResourceTypeRequest).withMarshaller((Marshaller)new GetComplianceSummaryByResourceTypeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetDiscoveredResourceCountsResponse getDiscoveredResourceCounts(GetDiscoveredResourceCountsRequest getDiscoveredResourceCountsRequest) throws ValidationException, InvalidLimitException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDiscoveredResourceCountsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetDiscoveredResourceCountsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDiscoveredResourceCountsRequest).withMarshaller((Marshaller)new GetDiscoveredResourceCountsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetResourceConfigHistoryResponse getResourceConfigHistory(GetResourceConfigHistoryRequest getResourceConfigHistoryRequest) throws ValidationException, InvalidTimeRangeException, InvalidLimitException, InvalidNextTokenException, NoAvailableConfigurationRecorderException, ResourceNotDiscoveredException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetResourceConfigHistoryResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetResourceConfigHistoryResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getResourceConfigHistoryRequest).withMarshaller((Marshaller)new GetResourceConfigHistoryRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetResourceConfigHistoryIterable getResourceConfigHistoryPaginator(GetResourceConfigHistoryRequest getResourceConfigHistoryRequest) throws ValidationException, InvalidTimeRangeException, InvalidLimitException, InvalidNextTokenException, NoAvailableConfigurationRecorderException, ResourceNotDiscoveredException, AwsServiceException, SdkClientException, ConfigException {
        return new GetResourceConfigHistoryIterable(this, this.applyPaginatorUserAgent(getResourceConfigHistoryRequest));
    }

    @Override
    public ListDiscoveredResourcesResponse listDiscoveredResources(ListDiscoveredResourcesRequest listDiscoveredResourcesRequest) throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoAvailableConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDiscoveredResourcesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListDiscoveredResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDiscoveredResourcesRequest).withMarshaller((Marshaller)new ListDiscoveredResourcesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutAggregationAuthorizationResponse putAggregationAuthorization(PutAggregationAuthorizationRequest putAggregationAuthorizationRequest) throws InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutAggregationAuthorizationResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (PutAggregationAuthorizationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putAggregationAuthorizationRequest).withMarshaller((Marshaller)new PutAggregationAuthorizationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutConfigRuleResponse putConfigRule(PutConfigRuleRequest putConfigRuleRequest) throws InvalidParameterValueException, MaxNumberOfConfigRulesExceededException, ResourceInUseException, InsufficientPermissionsException, NoAvailableConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutConfigRuleResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (PutConfigRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putConfigRuleRequest).withMarshaller((Marshaller)new PutConfigRuleRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutConfigurationAggregatorResponse putConfigurationAggregator(PutConfigurationAggregatorRequest putConfigurationAggregatorRequest) throws InvalidParameterValueException, LimitExceededException, InvalidRoleException, OrganizationAccessDeniedException, NoAvailableOrganizationException, OrganizationAllFeaturesNotEnabledException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutConfigurationAggregatorResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (PutConfigurationAggregatorResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putConfigurationAggregatorRequest).withMarshaller((Marshaller)new PutConfigurationAggregatorRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutConfigurationRecorderResponse putConfigurationRecorder(PutConfigurationRecorderRequest putConfigurationRecorderRequest) throws MaxNumberOfConfigurationRecordersExceededException, InvalidConfigurationRecorderNameException, InvalidRoleException, InvalidRecordingGroupException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutConfigurationRecorderResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (PutConfigurationRecorderResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putConfigurationRecorderRequest).withMarshaller((Marshaller)new PutConfigurationRecorderRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutDeliveryChannelResponse putDeliveryChannel(PutDeliveryChannelRequest putDeliveryChannelRequest) throws MaxNumberOfDeliveryChannelsExceededException, NoAvailableConfigurationRecorderException, InvalidDeliveryChannelNameException, NoSuchBucketException, InvalidS3KeyPrefixException, InvalidSnsTopicArnException, InsufficientDeliveryPolicyException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutDeliveryChannelResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (PutDeliveryChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putDeliveryChannelRequest).withMarshaller((Marshaller)new PutDeliveryChannelRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutEvaluationsResponse putEvaluations(PutEvaluationsRequest putEvaluationsRequest) throws InvalidParameterValueException, InvalidResultTokenException, NoSuchConfigRuleException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutEvaluationsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (PutEvaluationsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putEvaluationsRequest).withMarshaller((Marshaller)new PutEvaluationsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutRetentionConfigurationResponse putRetentionConfiguration(PutRetentionConfigurationRequest putRetentionConfigurationRequest) throws InvalidParameterValueException, MaxNumberOfRetentionConfigurationsExceededException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutRetentionConfigurationResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (PutRetentionConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putRetentionConfigurationRequest).withMarshaller((Marshaller)new PutRetentionConfigurationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public StartConfigRulesEvaluationResponse startConfigRulesEvaluation(StartConfigRulesEvaluationRequest startConfigRulesEvaluationRequest) throws NoSuchConfigRuleException, LimitExceededException, ResourceInUseException, InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartConfigRulesEvaluationResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (StartConfigRulesEvaluationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startConfigRulesEvaluationRequest).withMarshaller((Marshaller)new StartConfigRulesEvaluationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public StartConfigurationRecorderResponse startConfigurationRecorder(StartConfigurationRecorderRequest startConfigurationRecorderRequest) throws NoSuchConfigurationRecorderException, NoAvailableDeliveryChannelException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartConfigurationRecorderResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (StartConfigurationRecorderResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startConfigurationRecorderRequest).withMarshaller((Marshaller)new StartConfigurationRecorderRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public StopConfigurationRecorderResponse stopConfigurationRecorder(StopConfigurationRecorderRequest stopConfigurationRecorderRequest) throws NoSuchConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopConfigurationRecorderResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (StopConfigurationRecorderResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopConfigurationRecorderRequest).withMarshaller((Marshaller)new StopConfigurationRecorderRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(AwsJsonProtocolFactory protocolFactory) {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private AwsJsonProtocolFactory init(boolean supportsCbor) {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(supportsCbor).withSupportsIon(false).withBaseServiceExceptionClass(ConfigException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NoRunningConfigurationRecorderException").withModeledClass(NoRunningConfigurationRecorderException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotDiscoveredException").withModeledClass(ResourceNotDiscoveredException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterValueException").withModeledClass(InvalidParameterValueException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceInUseException").withModeledClass(ResourceInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NoAvailableDeliveryChannelException").withModeledClass(NoAvailableDeliveryChannelException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NoSuchRetentionConfigurationException").withModeledClass(NoSuchRetentionConfigurationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidResultTokenException").withModeledClass(InvalidResultTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MaxNumberOfConfigurationRecordersExceededException").withModeledClass(MaxNumberOfConfigurationRecordersExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InsufficientDeliveryPolicyException").withModeledClass(InsufficientDeliveryPolicyException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NoSuchConfigurationAggregatorException").withModeledClass(NoSuchConfigurationAggregatorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NoSuchBucketException").withModeledClass(NoSuchBucketException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OrganizationAccessDeniedException").withModeledClass(OrganizationAccessDeniedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NoAvailableConfigurationRecorderException").withModeledClass(NoAvailableConfigurationRecorderException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NoAvailableOrganizationException").withModeledClass(NoAvailableOrganizationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NoSuchDeliveryChannelException").withModeledClass(NoSuchDeliveryChannelException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(InvalidNextTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRecordingGroupException").withModeledClass(InvalidRecordingGroupException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidConfigurationRecorderNameException").withModeledClass(InvalidConfigurationRecorderNameException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LastDeliveryChannelDeleteFailedException").withModeledClass(LastDeliveryChannelDeleteFailedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OrganizationAllFeaturesNotEnabledException").withModeledClass(OrganizationAllFeaturesNotEnabledException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MaxNumberOfRetentionConfigurationsExceededException").withModeledClass(MaxNumberOfRetentionConfigurationsExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidTimeRangeException").withModeledClass(InvalidTimeRangeException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NoSuchConfigRuleException").withModeledClass(NoSuchConfigRuleException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidLimitException").withModeledClass(InvalidLimitException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRoleException").withModeledClass(InvalidRoleException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MaxNumberOfDeliveryChannelsExceededException").withModeledClass(MaxNumberOfDeliveryChannelsExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NoSuchConfigurationRecorderException").withModeledClass(NoSuchConfigurationRecorderException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withModeledClass(ValidationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidDeliveryChannelNameException").withModeledClass(InvalidDeliveryChannelNameException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MaxNumberOfConfigRulesExceededException").withModeledClass(MaxNumberOfConfigRulesExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InsufficientPermissionsException").withModeledClass(InsufficientPermissionsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidSNSTopicARNException").withModeledClass(InvalidSnsTopicArnException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidS3KeyPrefixException").withModeledClass(InvalidS3KeyPrefixException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends ConfigRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.0.0-preview-12").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ConfigRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

