/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ComplianceType;
import software.amazon.awssdk.services.config.model.EvaluationResultIdentifier;
import software.amazon.awssdk.services.config.transform.AggregateEvaluationResultMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregateEvaluationResult
implements StructuredPojo,
ToCopyableBuilder<Builder, AggregateEvaluationResult> {
    private final EvaluationResultIdentifier evaluationResultIdentifier;
    private final String complianceType;
    private final Instant resultRecordedTime;
    private final Instant configRuleInvokedTime;
    private final String annotation;
    private final String accountId;
    private final String awsRegion;

    private AggregateEvaluationResult(BuilderImpl builder) {
        this.evaluationResultIdentifier = builder.evaluationResultIdentifier;
        this.complianceType = builder.complianceType;
        this.resultRecordedTime = builder.resultRecordedTime;
        this.configRuleInvokedTime = builder.configRuleInvokedTime;
        this.annotation = builder.annotation;
        this.accountId = builder.accountId;
        this.awsRegion = builder.awsRegion;
    }

    public EvaluationResultIdentifier evaluationResultIdentifier() {
        return this.evaluationResultIdentifier;
    }

    public ComplianceType complianceType() {
        return ComplianceType.fromValue(this.complianceType);
    }

    public String complianceTypeAsString() {
        return this.complianceType;
    }

    public Instant resultRecordedTime() {
        return this.resultRecordedTime;
    }

    public Instant configRuleInvokedTime() {
        return this.configRuleInvokedTime;
    }

    public String annotation() {
        return this.annotation;
    }

    public String accountId() {
        return this.accountId;
    }

    public String awsRegion() {
        return this.awsRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationResultIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultRecordedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleInvokedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.annotation());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateEvaluationResult)) {
            return false;
        }
        AggregateEvaluationResult other = (AggregateEvaluationResult)obj;
        return Objects.equals(this.evaluationResultIdentifier(), other.evaluationResultIdentifier()) && Objects.equals(this.complianceTypeAsString(), other.complianceTypeAsString()) && Objects.equals(this.resultRecordedTime(), other.resultRecordedTime()) && Objects.equals(this.configRuleInvokedTime(), other.configRuleInvokedTime()) && Objects.equals(this.annotation(), other.annotation()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.awsRegion(), other.awsRegion());
    }

    public String toString() {
        return ToString.builder((String)"AggregateEvaluationResult").add("EvaluationResultIdentifier", (Object)this.evaluationResultIdentifier()).add("ComplianceType", (Object)this.complianceTypeAsString()).add("ResultRecordedTime", (Object)this.resultRecordedTime()).add("ConfigRuleInvokedTime", (Object)this.configRuleInvokedTime()).add("Annotation", (Object)this.annotation()).add("AccountId", (Object)this.accountId()).add("AwsRegion", (Object)this.awsRegion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvaluationResultIdentifier": {
                return Optional.ofNullable(clazz.cast(this.evaluationResultIdentifier()));
            }
            case "ComplianceType": {
                return Optional.ofNullable(clazz.cast(this.complianceTypeAsString()));
            }
            case "ResultRecordedTime": {
                return Optional.ofNullable(clazz.cast(this.resultRecordedTime()));
            }
            case "ConfigRuleInvokedTime": {
                return Optional.ofNullable(clazz.cast(this.configRuleInvokedTime()));
            }
            case "Annotation": {
                return Optional.ofNullable(clazz.cast(this.annotation()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "AwsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AggregateEvaluationResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private EvaluationResultIdentifier evaluationResultIdentifier;
        private String complianceType;
        private Instant resultRecordedTime;
        private Instant configRuleInvokedTime;
        private String annotation;
        private String accountId;
        private String awsRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateEvaluationResult model) {
            this.evaluationResultIdentifier(model.evaluationResultIdentifier);
            this.complianceType(model.complianceType);
            this.resultRecordedTime(model.resultRecordedTime);
            this.configRuleInvokedTime(model.configRuleInvokedTime);
            this.annotation(model.annotation);
            this.accountId(model.accountId);
            this.awsRegion(model.awsRegion);
        }

        public final EvaluationResultIdentifier.Builder getEvaluationResultIdentifier() {
            return this.evaluationResultIdentifier != null ? this.evaluationResultIdentifier.toBuilder() : null;
        }

        @Override
        public final Builder evaluationResultIdentifier(EvaluationResultIdentifier evaluationResultIdentifier) {
            this.evaluationResultIdentifier = evaluationResultIdentifier;
            return this;
        }

        public final void setEvaluationResultIdentifier(EvaluationResultIdentifier.BuilderImpl evaluationResultIdentifier) {
            this.evaluationResultIdentifier = evaluationResultIdentifier != null ? evaluationResultIdentifier.build() : null;
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ComplianceType complianceType) {
            this.complianceType(complianceType.toString());
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final Instant getResultRecordedTime() {
            return this.resultRecordedTime;
        }

        @Override
        public final Builder resultRecordedTime(Instant resultRecordedTime) {
            this.resultRecordedTime = resultRecordedTime;
            return this;
        }

        public final void setResultRecordedTime(Instant resultRecordedTime) {
            this.resultRecordedTime = resultRecordedTime;
        }

        public final Instant getConfigRuleInvokedTime() {
            return this.configRuleInvokedTime;
        }

        @Override
        public final Builder configRuleInvokedTime(Instant configRuleInvokedTime) {
            this.configRuleInvokedTime = configRuleInvokedTime;
            return this;
        }

        public final void setConfigRuleInvokedTime(Instant configRuleInvokedTime) {
            this.configRuleInvokedTime = configRuleInvokedTime;
        }

        public final String getAnnotation() {
            return this.annotation;
        }

        @Override
        public final Builder annotation(String annotation) {
            this.annotation = annotation;
            return this;
        }

        public final void setAnnotation(String annotation) {
            this.annotation = annotation;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public AggregateEvaluationResult build() {
            return new AggregateEvaluationResult(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AggregateEvaluationResult> {
        public Builder evaluationResultIdentifier(EvaluationResultIdentifier var1);

        default public Builder evaluationResultIdentifier(Consumer<EvaluationResultIdentifier.Builder> evaluationResultIdentifier) {
            return this.evaluationResultIdentifier((EvaluationResultIdentifier)((EvaluationResultIdentifier.Builder)EvaluationResultIdentifier.builder().applyMutation(evaluationResultIdentifier)).build());
        }

        public Builder complianceType(String var1);

        public Builder complianceType(ComplianceType var1);

        public Builder resultRecordedTime(Instant var1);

        public Builder configRuleInvokedTime(Instant var1);

        public Builder annotation(String var1);

        public Builder accountId(String var1);

        public Builder awsRegion(String var1);
    }
}

