/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.config.model.AccountAggregationSource;
import software.amazon.awssdk.services.config.model.AccountAggregationSourceListCopier;
import software.amazon.awssdk.services.config.model.OrganizationAggregationSource;
import software.amazon.awssdk.services.config.transform.ConfigurationAggregatorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationAggregator
implements StructuredPojo,
ToCopyableBuilder<Builder, ConfigurationAggregator> {
    private final String configurationAggregatorName;
    private final String configurationAggregatorArn;
    private final List<AccountAggregationSource> accountAggregationSources;
    private final OrganizationAggregationSource organizationAggregationSource;
    private final Instant creationTime;
    private final Instant lastUpdatedTime;

    private ConfigurationAggregator(BuilderImpl builder) {
        this.configurationAggregatorName = builder.configurationAggregatorName;
        this.configurationAggregatorArn = builder.configurationAggregatorArn;
        this.accountAggregationSources = builder.accountAggregationSources;
        this.organizationAggregationSource = builder.organizationAggregationSource;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    public String configurationAggregatorName() {
        return this.configurationAggregatorName;
    }

    public String configurationAggregatorArn() {
        return this.configurationAggregatorArn;
    }

    public List<AccountAggregationSource> accountAggregationSources() {
        return this.accountAggregationSources;
    }

    public OrganizationAggregationSource organizationAggregationSource() {
        return this.organizationAggregationSource;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationAggregatorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationAggregatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountAggregationSources());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationAggregationSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationAggregator)) {
            return false;
        }
        ConfigurationAggregator other = (ConfigurationAggregator)obj;
        return Objects.equals(this.configurationAggregatorName(), other.configurationAggregatorName()) && Objects.equals(this.configurationAggregatorArn(), other.configurationAggregatorArn()) && Objects.equals(this.accountAggregationSources(), other.accountAggregationSources()) && Objects.equals(this.organizationAggregationSource(), other.organizationAggregationSource()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime());
    }

    public String toString() {
        return ToString.builder((String)"ConfigurationAggregator").add("ConfigurationAggregatorName", (Object)this.configurationAggregatorName()).add("ConfigurationAggregatorArn", (Object)this.configurationAggregatorArn()).add("AccountAggregationSources", this.accountAggregationSources()).add("OrganizationAggregationSource", (Object)this.organizationAggregationSource()).add("CreationTime", (Object)this.creationTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationAggregatorName": {
                return Optional.ofNullable(clazz.cast(this.configurationAggregatorName()));
            }
            case "ConfigurationAggregatorArn": {
                return Optional.ofNullable(clazz.cast(this.configurationAggregatorArn()));
            }
            case "AccountAggregationSources": {
                return Optional.ofNullable(clazz.cast(this.accountAggregationSources()));
            }
            case "OrganizationAggregationSource": {
                return Optional.ofNullable(clazz.cast(this.organizationAggregationSource()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigurationAggregatorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String configurationAggregatorName;
        private String configurationAggregatorArn;
        private List<AccountAggregationSource> accountAggregationSources = DefaultSdkAutoConstructList.getInstance();
        private OrganizationAggregationSource organizationAggregationSource;
        private Instant creationTime;
        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationAggregator model) {
            this.configurationAggregatorName(model.configurationAggregatorName);
            this.configurationAggregatorArn(model.configurationAggregatorArn);
            this.accountAggregationSources(model.accountAggregationSources);
            this.organizationAggregationSource(model.organizationAggregationSource);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getConfigurationAggregatorName() {
            return this.configurationAggregatorName;
        }

        @Override
        public final Builder configurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
            return this;
        }

        public final void setConfigurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
        }

        public final String getConfigurationAggregatorArn() {
            return this.configurationAggregatorArn;
        }

        @Override
        public final Builder configurationAggregatorArn(String configurationAggregatorArn) {
            this.configurationAggregatorArn = configurationAggregatorArn;
            return this;
        }

        public final void setConfigurationAggregatorArn(String configurationAggregatorArn) {
            this.configurationAggregatorArn = configurationAggregatorArn;
        }

        public final Collection<AccountAggregationSource.Builder> getAccountAggregationSources() {
            return this.accountAggregationSources != null ? (Collection)this.accountAggregationSources.stream().map(AccountAggregationSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accountAggregationSources(Collection<AccountAggregationSource> accountAggregationSources) {
            this.accountAggregationSources = AccountAggregationSourceListCopier.copy(accountAggregationSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAggregationSources(AccountAggregationSource ... accountAggregationSources) {
            this.accountAggregationSources(Arrays.asList(accountAggregationSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAggregationSources(Consumer<AccountAggregationSource.Builder> ... accountAggregationSources) {
            this.accountAggregationSources(Stream.of(accountAggregationSources).map(c -> (AccountAggregationSource)((AccountAggregationSource.Builder)AccountAggregationSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccountAggregationSources(Collection<AccountAggregationSource.BuilderImpl> accountAggregationSources) {
            this.accountAggregationSources = AccountAggregationSourceListCopier.copyFromBuilder(accountAggregationSources);
        }

        public final OrganizationAggregationSource.Builder getOrganizationAggregationSource() {
            return this.organizationAggregationSource != null ? this.organizationAggregationSource.toBuilder() : null;
        }

        @Override
        public final Builder organizationAggregationSource(OrganizationAggregationSource organizationAggregationSource) {
            this.organizationAggregationSource = organizationAggregationSource;
            return this;
        }

        public final void setOrganizationAggregationSource(OrganizationAggregationSource.BuilderImpl organizationAggregationSource) {
            this.organizationAggregationSource = organizationAggregationSource != null ? organizationAggregationSource.build() : null;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public ConfigurationAggregator build() {
            return new ConfigurationAggregator(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConfigurationAggregator> {
        public Builder configurationAggregatorName(String var1);

        public Builder configurationAggregatorArn(String var1);

        public Builder accountAggregationSources(Collection<AccountAggregationSource> var1);

        public Builder accountAggregationSources(AccountAggregationSource ... var1);

        public Builder accountAggregationSources(Consumer<AccountAggregationSource.Builder> ... var1);

        public Builder organizationAggregationSource(OrganizationAggregationSource var1);

        default public Builder organizationAggregationSource(Consumer<OrganizationAggregationSource.Builder> organizationAggregationSource) {
            return this.organizationAggregationSource((OrganizationAggregationSource)((OrganizationAggregationSource.Builder)OrganizationAggregationSource.builder().applyMutation(organizationAggregationSource)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);
    }
}

