/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.config.model.AggregatorRegionListCopier;
import software.amazon.awssdk.services.config.transform.OrganizationAggregationSourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrganizationAggregationSource
implements StructuredPojo,
ToCopyableBuilder<Builder, OrganizationAggregationSource> {
    private final String roleArn;
    private final List<String> awsRegions;
    private final Boolean allAwsRegions;

    private OrganizationAggregationSource(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.awsRegions = builder.awsRegions;
        this.allAwsRegions = builder.allAwsRegions;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public List<String> awsRegions() {
        return this.awsRegions;
    }

    public Boolean allAwsRegions() {
        return this.allAwsRegions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegions());
        hashCode = 31 * hashCode + Objects.hashCode(this.allAwsRegions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationAggregationSource)) {
            return false;
        }
        OrganizationAggregationSource other = (OrganizationAggregationSource)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.awsRegions(), other.awsRegions()) && Objects.equals(this.allAwsRegions(), other.allAwsRegions());
    }

    public String toString() {
        return ToString.builder((String)"OrganizationAggregationSource").add("RoleArn", (Object)this.roleArn()).add("AwsRegions", this.awsRegions()).add("AllAwsRegions", (Object)this.allAwsRegions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "AwsRegions": {
                return Optional.ofNullable(clazz.cast(this.awsRegions()));
            }
            case "AllAwsRegions": {
                return Optional.ofNullable(clazz.cast(this.allAwsRegions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OrganizationAggregationSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private List<String> awsRegions = DefaultSdkAutoConstructList.getInstance();
        private Boolean allAwsRegions;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationAggregationSource model) {
            this.roleArn(model.roleArn);
            this.awsRegions(model.awsRegions);
            this.allAwsRegions(model.allAwsRegions);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Collection<String> getAwsRegions() {
            return this.awsRegions;
        }

        @Override
        public final Builder awsRegions(Collection<String> awsRegions) {
            this.awsRegions = AggregatorRegionListCopier.copy(awsRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsRegions(String ... awsRegions) {
            this.awsRegions(Arrays.asList(awsRegions));
            return this;
        }

        public final void setAwsRegions(Collection<String> awsRegions) {
            this.awsRegions = AggregatorRegionListCopier.copy(awsRegions);
        }

        public final Boolean getAllAwsRegions() {
            return this.allAwsRegions;
        }

        @Override
        public final Builder allAwsRegions(Boolean allAwsRegions) {
            this.allAwsRegions = allAwsRegions;
            return this;
        }

        public final void setAllAwsRegions(Boolean allAwsRegions) {
            this.allAwsRegions = allAwsRegions;
        }

        public OrganizationAggregationSource build() {
            return new OrganizationAggregationSource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OrganizationAggregationSource> {
        public Builder roleArn(String var1);

        public Builder awsRegions(Collection<String> var1);

        public Builder awsRegions(String ... var1);

        public Builder allAwsRegions(Boolean var1);
    }
}

