/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.PendingAggregationRequestMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PendingAggregationRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, PendingAggregationRequest> {
    private final String requesterAccountId;
    private final String requesterAwsRegion;

    private PendingAggregationRequest(BuilderImpl builder) {
        this.requesterAccountId = builder.requesterAccountId;
        this.requesterAwsRegion = builder.requesterAwsRegion;
    }

    public String requesterAccountId() {
        return this.requesterAccountId;
    }

    public String requesterAwsRegion() {
        return this.requesterAwsRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterAwsRegion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingAggregationRequest)) {
            return false;
        }
        PendingAggregationRequest other = (PendingAggregationRequest)obj;
        return Objects.equals(this.requesterAccountId(), other.requesterAccountId()) && Objects.equals(this.requesterAwsRegion(), other.requesterAwsRegion());
    }

    public String toString() {
        return ToString.builder((String)"PendingAggregationRequest").add("RequesterAccountId", (Object)this.requesterAccountId()).add("RequesterAwsRegion", (Object)this.requesterAwsRegion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RequesterAccountId": {
                return Optional.ofNullable(clazz.cast(this.requesterAccountId()));
            }
            case "RequesterAwsRegion": {
                return Optional.ofNullable(clazz.cast(this.requesterAwsRegion()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PendingAggregationRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String requesterAccountId;
        private String requesterAwsRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingAggregationRequest model) {
            this.requesterAccountId(model.requesterAccountId);
            this.requesterAwsRegion(model.requesterAwsRegion);
        }

        public final String getRequesterAccountId() {
            return this.requesterAccountId;
        }

        @Override
        public final Builder requesterAccountId(String requesterAccountId) {
            this.requesterAccountId = requesterAccountId;
            return this;
        }

        public final void setRequesterAccountId(String requesterAccountId) {
            this.requesterAccountId = requesterAccountId;
        }

        public final String getRequesterAwsRegion() {
            return this.requesterAwsRegion;
        }

        @Override
        public final Builder requesterAwsRegion(String requesterAwsRegion) {
            this.requesterAwsRegion = requesterAwsRegion;
            return this;
        }

        public final void setRequesterAwsRegion(String requesterAwsRegion) {
            this.requesterAwsRegion = requesterAwsRegion;
        }

        public PendingAggregationRequest build() {
            return new PendingAggregationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PendingAggregationRequest> {
        public Builder requesterAccountId(String var1);

        public Builder requesterAwsRegion(String var1);
    }
}

