/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.RetentionConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetentionConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, RetentionConfiguration> {
    private final String name;
    private final Integer retentionPeriodInDays;

    private RetentionConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.retentionPeriodInDays = builder.retentionPeriodInDays;
    }

    public String name() {
        return this.name;
    }

    public Integer retentionPeriodInDays() {
        return this.retentionPeriodInDays;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriodInDays());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetentionConfiguration)) {
            return false;
        }
        RetentionConfiguration other = (RetentionConfiguration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.retentionPeriodInDays(), other.retentionPeriodInDays());
    }

    public String toString() {
        return ToString.builder((String)"RetentionConfiguration").add("Name", (Object)this.name()).add("RetentionPeriodInDays", (Object)this.retentionPeriodInDays()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RetentionPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriodInDays()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RetentionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Integer retentionPeriodInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(RetentionConfiguration model) {
            this.name(model.name);
            this.retentionPeriodInDays(model.retentionPeriodInDays);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getRetentionPeriodInDays() {
            return this.retentionPeriodInDays;
        }

        @Override
        public final Builder retentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
            return this;
        }

        public final void setRetentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
        }

        public RetentionConfiguration build() {
            return new RetentionConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RetentionConfiguration> {
        public Builder name(String var1);

        public Builder retentionPeriodInDays(Integer var1);
    }
}

