/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.AccountAggregationSource;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AccountAggregationSourceMarshaller {
    private static final MarshallingInfo<List> ACCOUNTIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountIds").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ALLAWSREGIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllAwsRegions").isBinary(false).build();
    private static final MarshallingInfo<List> AWSREGIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AwsRegions").isBinary(false).build();
    private static final AccountAggregationSourceMarshaller INSTANCE = new AccountAggregationSourceMarshaller();

    private AccountAggregationSourceMarshaller() {
    }

    public static AccountAggregationSourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AccountAggregationSource accountAggregationSource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)accountAggregationSource, (String)"accountAggregationSource");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(accountAggregationSource.accountIds(), ACCOUNTIDS_BINDING);
            protocolMarshaller.marshall((Object)accountAggregationSource.allAwsRegions(), ALLAWSREGIONS_BINDING);
            protocolMarshaller.marshall(accountAggregationSource.awsRegions(), AWSREGIONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

