/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.AggregateComplianceCount;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AggregateComplianceCountMarshaller {
    private static final MarshallingInfo<String> GROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GroupName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> COMPLIANCESUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceSummary").isBinary(false).build();
    private static final AggregateComplianceCountMarshaller INSTANCE = new AggregateComplianceCountMarshaller();

    private AggregateComplianceCountMarshaller() {
    }

    public static AggregateComplianceCountMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AggregateComplianceCount aggregateComplianceCount, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)aggregateComplianceCount, (String)"aggregateComplianceCount");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)aggregateComplianceCount.groupName(), GROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)aggregateComplianceCount.complianceSummary(), COMPLIANCESUMMARY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

