/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.AggregatedSourceStatus;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AggregatedSourceStatusMarshaller {
    private static final MarshallingInfo<String> SOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceId").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceType").isBinary(false).build();
    private static final MarshallingInfo<String> AWSREGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AwsRegion").isBinary(false).build();
    private static final MarshallingInfo<String> LASTUPDATESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdateStatus").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTUPDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdateTime").isBinary(false).build();
    private static final MarshallingInfo<String> LASTERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastErrorCode").isBinary(false).build();
    private static final MarshallingInfo<String> LASTERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastErrorMessage").isBinary(false).build();
    private static final AggregatedSourceStatusMarshaller INSTANCE = new AggregatedSourceStatusMarshaller();

    private AggregatedSourceStatusMarshaller() {
    }

    public static AggregatedSourceStatusMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AggregatedSourceStatus aggregatedSourceStatus, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)aggregatedSourceStatus, (String)"aggregatedSourceStatus");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)aggregatedSourceStatus.sourceId(), SOURCEID_BINDING);
            protocolMarshaller.marshall((Object)aggregatedSourceStatus.sourceTypeAsString(), SOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)aggregatedSourceStatus.awsRegion(), AWSREGION_BINDING);
            protocolMarshaller.marshall((Object)aggregatedSourceStatus.lastUpdateStatusAsString(), LASTUPDATESTATUS_BINDING);
            protocolMarshaller.marshall((Object)aggregatedSourceStatus.lastUpdateTime(), LASTUPDATETIME_BINDING);
            protocolMarshaller.marshall((Object)aggregatedSourceStatus.lastErrorCode(), LASTERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)aggregatedSourceStatus.lastErrorMessage(), LASTERRORMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

