/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.config.model.BatchGetResourceConfigRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchGetResourceConfigRequestModelMarshaller {
    private static final MarshallingInfo<List> RESOURCEKEYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceKeys").isBinary(false).build();
    private static final BatchGetResourceConfigRequestModelMarshaller INSTANCE = new BatchGetResourceConfigRequestModelMarshaller();

    private BatchGetResourceConfigRequestModelMarshaller() {
    }

    public static BatchGetResourceConfigRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchGetResourceConfigRequest batchGetResourceConfigRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)batchGetResourceConfigRequest), (String)"batchGetResourceConfigRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(batchGetResourceConfigRequest.resourceKeys(), RESOURCEKEYS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

