/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.Compliance;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ComplianceMarshaller {
    private static final MarshallingInfo<String> COMPLIANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceType").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> COMPLIANCECONTRIBUTORCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceContributorCount").isBinary(false).build();
    private static final ComplianceMarshaller INSTANCE = new ComplianceMarshaller();

    private ComplianceMarshaller() {
    }

    public static ComplianceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Compliance compliance, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)compliance, (String)"compliance");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)compliance.complianceTypeAsString(), COMPLIANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)compliance.complianceContributorCount(), COMPLIANCECONTRIBUTORCOUNT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

