/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.ComplianceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates whether an AWS resource or AWS Config rule is compliant and provides the number of contributors that affect
 * the compliance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Compliance implements StructuredPojo, ToCopyableBuilder<Compliance.Builder, Compliance> {
    private final String complianceType;

    private final ComplianceContributorCount complianceContributorCount;

    private Compliance(BuilderImpl builder) {
        this.complianceType = builder.complianceType;
        this.complianceContributorCount = builder.complianceContributorCount;
    }

    /**
     * <p>
     * Indicates whether an AWS resource or AWS Config rule is compliant.
     * </p>
     * <p>
     * A resource is compliant if it complies with all of the AWS Config rules that evaluate it, and it is noncompliant
     * if it does not comply with one or more of these rules.
     * </p>
     * <p>
     * A rule is compliant if all of the resources that the rule evaluates comply with it, and it is noncompliant if any
     * of these resources do not comply.
     * </p>
     * <p>
     * AWS Config returns the <code>INSUFFICIENT_DATA</code> value when no evaluation results are available for the AWS
     * resource or Config rule.
     * </p>
     * <p>
     * For the <code>Compliance</code> data type, AWS Config supports only <code>COMPLIANT</code>,
     * <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code> values. AWS Config does not support the
     * <code>NOT_APPLICABLE</code> value for the <code>Compliance</code> data type.
     * </p>
     * 
     * @return Indicates whether an AWS resource or AWS Config rule is compliant.</p>
     *         <p>
     *         A resource is compliant if it complies with all of the AWS Config rules that evaluate it, and it is
     *         noncompliant if it does not comply with one or more of these rules.
     *         </p>
     *         <p>
     *         A rule is compliant if all of the resources that the rule evaluates comply with it, and it is
     *         noncompliant if any of these resources do not comply.
     *         </p>
     *         <p>
     *         AWS Config returns the <code>INSUFFICIENT_DATA</code> value when no evaluation results are available for
     *         the AWS resource or Config rule.
     *         </p>
     *         <p>
     *         For the <code>Compliance</code> data type, AWS Config supports only <code>COMPLIANT</code>,
     *         <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code> values. AWS Config does not support the
     *         <code>NOT_APPLICABLE</code> value for the <code>Compliance</code> data type.
     * @see ComplianceType
     */
    public String complianceType() {
        return complianceType;
    }

    /**
     * <p>
     * The number of AWS resources or AWS Config rules that cause a result of <code>NON_COMPLIANT</code>, up to a
     * maximum number.
     * </p>
     * 
     * @return The number of AWS resources or AWS Config rules that cause a result of <code>NON_COMPLIANT</code>, up to
     *         a maximum number.
     */
    public ComplianceContributorCount complianceContributorCount() {
        return complianceContributorCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((complianceType() == null) ? 0 : complianceType().hashCode());
        hashCode = 31 * hashCode + ((complianceContributorCount() == null) ? 0 : complianceContributorCount().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Compliance)) {
            return false;
        }
        Compliance other = (Compliance) obj;
        if (other.complianceType() == null ^ this.complianceType() == null) {
            return false;
        }
        if (other.complianceType() != null && !other.complianceType().equals(this.complianceType())) {
            return false;
        }
        if (other.complianceContributorCount() == null ^ this.complianceContributorCount() == null) {
            return false;
        }
        if (other.complianceContributorCount() != null
                && !other.complianceContributorCount().equals(this.complianceContributorCount())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (complianceType() != null) {
            sb.append("ComplianceType: ").append(complianceType()).append(",");
        }
        if (complianceContributorCount() != null) {
            sb.append("ComplianceContributorCount: ").append(complianceContributorCount()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComplianceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Compliance> {
        /**
         * <p>
         * Indicates whether an AWS resource or AWS Config rule is compliant.
         * </p>
         * <p>
         * A resource is compliant if it complies with all of the AWS Config rules that evaluate it, and it is
         * noncompliant if it does not comply with one or more of these rules.
         * </p>
         * <p>
         * A rule is compliant if all of the resources that the rule evaluates comply with it, and it is noncompliant if
         * any of these resources do not comply.
         * </p>
         * <p>
         * AWS Config returns the <code>INSUFFICIENT_DATA</code> value when no evaluation results are available for the
         * AWS resource or Config rule.
         * </p>
         * <p>
         * For the <code>Compliance</code> data type, AWS Config supports only <code>COMPLIANT</code>,
         * <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code> values. AWS Config does not support the
         * <code>NOT_APPLICABLE</code> value for the <code>Compliance</code> data type.
         * </p>
         * 
         * @param complianceType
         *        Indicates whether an AWS resource or AWS Config rule is compliant.</p>
         *        <p>
         *        A resource is compliant if it complies with all of the AWS Config rules that evaluate it, and it is
         *        noncompliant if it does not comply with one or more of these rules.
         *        </p>
         *        <p>
         *        A rule is compliant if all of the resources that the rule evaluates comply with it, and it is
         *        noncompliant if any of these resources do not comply.
         *        </p>
         *        <p>
         *        AWS Config returns the <code>INSUFFICIENT_DATA</code> value when no evaluation results are available
         *        for the AWS resource or Config rule.
         *        </p>
         *        <p>
         *        For the <code>Compliance</code> data type, AWS Config supports only <code>COMPLIANT</code>,
         *        <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code> values. AWS Config does not support the
         *        <code>NOT_APPLICABLE</code> value for the <code>Compliance</code> data type.
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * Indicates whether an AWS resource or AWS Config rule is compliant.
         * </p>
         * <p>
         * A resource is compliant if it complies with all of the AWS Config rules that evaluate it, and it is
         * noncompliant if it does not comply with one or more of these rules.
         * </p>
         * <p>
         * A rule is compliant if all of the resources that the rule evaluates comply with it, and it is noncompliant if
         * any of these resources do not comply.
         * </p>
         * <p>
         * AWS Config returns the <code>INSUFFICIENT_DATA</code> value when no evaluation results are available for the
         * AWS resource or Config rule.
         * </p>
         * <p>
         * For the <code>Compliance</code> data type, AWS Config supports only <code>COMPLIANT</code>,
         * <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code> values. AWS Config does not support the
         * <code>NOT_APPLICABLE</code> value for the <code>Compliance</code> data type.
         * </p>
         * 
         * @param complianceType
         *        Indicates whether an AWS resource or AWS Config rule is compliant.</p>
         *        <p>
         *        A resource is compliant if it complies with all of the AWS Config rules that evaluate it, and it is
         *        noncompliant if it does not comply with one or more of these rules.
         *        </p>
         *        <p>
         *        A rule is compliant if all of the resources that the rule evaluates comply with it, and it is
         *        noncompliant if any of these resources do not comply.
         *        </p>
         *        <p>
         *        AWS Config returns the <code>INSUFFICIENT_DATA</code> value when no evaluation results are available
         *        for the AWS resource or Config rule.
         *        </p>
         *        <p>
         *        For the <code>Compliance</code> data type, AWS Config supports only <code>COMPLIANT</code>,
         *        <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code> values. AWS Config does not support the
         *        <code>NOT_APPLICABLE</code> value for the <code>Compliance</code> data type.
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder complianceType(ComplianceType complianceType);

        /**
         * <p>
         * The number of AWS resources or AWS Config rules that cause a result of <code>NON_COMPLIANT</code>, up to a
         * maximum number.
         * </p>
         * 
         * @param complianceContributorCount
         *        The number of AWS resources or AWS Config rules that cause a result of <code>NON_COMPLIANT</code>, up
         *        to a maximum number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceContributorCount(ComplianceContributorCount complianceContributorCount);
    }

    private static final class BuilderImpl implements Builder {
        private String complianceType;

        private ComplianceContributorCount complianceContributorCount;

        private BuilderImpl() {
        }

        private BuilderImpl(Compliance model) {
            setComplianceType(model.complianceType);
            setComplianceContributorCount(model.complianceContributorCount);
        }

        public final String getComplianceType() {
            return complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ComplianceType complianceType) {
            this.complianceType(complianceType.toString());
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final void setComplianceType(ComplianceType complianceType) {
            this.complianceType(complianceType.toString());
        }

        public final ComplianceContributorCount getComplianceContributorCount() {
            return complianceContributorCount;
        }

        @Override
        public final Builder complianceContributorCount(ComplianceContributorCount complianceContributorCount) {
            this.complianceContributorCount = complianceContributorCount;
            return this;
        }

        public final void setComplianceContributorCount(ComplianceContributorCount complianceContributorCount) {
            this.complianceContributorCount = complianceContributorCount;
        }

        @Override
        public Compliance build() {
            return new Compliance(this);
        }
    }
}
