/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.ConfigurationRecorderStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The current status of the configuration recorder.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ConfigurationRecorderStatus implements StructuredPojo,
        ToCopyableBuilder<ConfigurationRecorderStatus.Builder, ConfigurationRecorderStatus> {
    private final String name;

    private final Instant lastStartTime;

    private final Instant lastStopTime;

    private final Boolean recording;

    private final String lastStatus;

    private final String lastErrorCode;

    private final String lastErrorMessage;

    private final Instant lastStatusChangeTime;

    private ConfigurationRecorderStatus(BuilderImpl builder) {
        this.name = builder.name;
        this.lastStartTime = builder.lastStartTime;
        this.lastStopTime = builder.lastStopTime;
        this.recording = builder.recording;
        this.lastStatus = builder.lastStatus;
        this.lastErrorCode = builder.lastErrorCode;
        this.lastErrorMessage = builder.lastErrorMessage;
        this.lastStatusChangeTime = builder.lastStatusChangeTime;
    }

    /**
     * <p>
     * The name of the configuration recorder.
     * </p>
     * 
     * @return The name of the configuration recorder.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The time the recorder was last started.
     * </p>
     * 
     * @return The time the recorder was last started.
     */
    public Instant lastStartTime() {
        return lastStartTime;
    }

    /**
     * <p>
     * The time the recorder was last stopped.
     * </p>
     * 
     * @return The time the recorder was last stopped.
     */
    public Instant lastStopTime() {
        return lastStopTime;
    }

    /**
     * <p>
     * Specifies whether the recorder is currently recording or not.
     * </p>
     * 
     * @return Specifies whether the recorder is currently recording or not.
     */
    public Boolean recording() {
        return recording;
    }

    /**
     * <p>
     * The last (previous) status of the recorder.
     * </p>
     * 
     * @return The last (previous) status of the recorder.
     * @see RecorderStatus
     */
    public String lastStatus() {
        return lastStatus;
    }

    /**
     * <p>
     * The error code indicating that the recording failed.
     * </p>
     * 
     * @return The error code indicating that the recording failed.
     */
    public String lastErrorCode() {
        return lastErrorCode;
    }

    /**
     * <p>
     * The message indicating that the recording failed due to an error.
     * </p>
     * 
     * @return The message indicating that the recording failed due to an error.
     */
    public String lastErrorMessage() {
        return lastErrorMessage;
    }

    /**
     * <p>
     * The time when the status was last changed.
     * </p>
     * 
     * @return The time when the status was last changed.
     */
    public Instant lastStatusChangeTime() {
        return lastStatusChangeTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((lastStartTime() == null) ? 0 : lastStartTime().hashCode());
        hashCode = 31 * hashCode + ((lastStopTime() == null) ? 0 : lastStopTime().hashCode());
        hashCode = 31 * hashCode + ((recording() == null) ? 0 : recording().hashCode());
        hashCode = 31 * hashCode + ((lastStatus() == null) ? 0 : lastStatus().hashCode());
        hashCode = 31 * hashCode + ((lastErrorCode() == null) ? 0 : lastErrorCode().hashCode());
        hashCode = 31 * hashCode + ((lastErrorMessage() == null) ? 0 : lastErrorMessage().hashCode());
        hashCode = 31 * hashCode + ((lastStatusChangeTime() == null) ? 0 : lastStatusChangeTime().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationRecorderStatus)) {
            return false;
        }
        ConfigurationRecorderStatus other = (ConfigurationRecorderStatus) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.lastStartTime() == null ^ this.lastStartTime() == null) {
            return false;
        }
        if (other.lastStartTime() != null && !other.lastStartTime().equals(this.lastStartTime())) {
            return false;
        }
        if (other.lastStopTime() == null ^ this.lastStopTime() == null) {
            return false;
        }
        if (other.lastStopTime() != null && !other.lastStopTime().equals(this.lastStopTime())) {
            return false;
        }
        if (other.recording() == null ^ this.recording() == null) {
            return false;
        }
        if (other.recording() != null && !other.recording().equals(this.recording())) {
            return false;
        }
        if (other.lastStatus() == null ^ this.lastStatus() == null) {
            return false;
        }
        if (other.lastStatus() != null && !other.lastStatus().equals(this.lastStatus())) {
            return false;
        }
        if (other.lastErrorCode() == null ^ this.lastErrorCode() == null) {
            return false;
        }
        if (other.lastErrorCode() != null && !other.lastErrorCode().equals(this.lastErrorCode())) {
            return false;
        }
        if (other.lastErrorMessage() == null ^ this.lastErrorMessage() == null) {
            return false;
        }
        if (other.lastErrorMessage() != null && !other.lastErrorMessage().equals(this.lastErrorMessage())) {
            return false;
        }
        if (other.lastStatusChangeTime() == null ^ this.lastStatusChangeTime() == null) {
            return false;
        }
        if (other.lastStatusChangeTime() != null && !other.lastStatusChangeTime().equals(this.lastStatusChangeTime())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (lastStartTime() != null) {
            sb.append("LastStartTime: ").append(lastStartTime()).append(",");
        }
        if (lastStopTime() != null) {
            sb.append("LastStopTime: ").append(lastStopTime()).append(",");
        }
        if (recording() != null) {
            sb.append("Recording: ").append(recording()).append(",");
        }
        if (lastStatus() != null) {
            sb.append("LastStatus: ").append(lastStatus()).append(",");
        }
        if (lastErrorCode() != null) {
            sb.append("LastErrorCode: ").append(lastErrorCode()).append(",");
        }
        if (lastErrorMessage() != null) {
            sb.append("LastErrorMessage: ").append(lastErrorMessage()).append(",");
        }
        if (lastStatusChangeTime() != null) {
            sb.append("LastStatusChangeTime: ").append(lastStatusChangeTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigurationRecorderStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ConfigurationRecorderStatus> {
        /**
         * <p>
         * The name of the configuration recorder.
         * </p>
         * 
         * @param name
         *        The name of the configuration recorder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time the recorder was last started.
         * </p>
         * 
         * @param lastStartTime
         *        The time the recorder was last started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStartTime(Instant lastStartTime);

        /**
         * <p>
         * The time the recorder was last stopped.
         * </p>
         * 
         * @param lastStopTime
         *        The time the recorder was last stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStopTime(Instant lastStopTime);

        /**
         * <p>
         * Specifies whether the recorder is currently recording or not.
         * </p>
         * 
         * @param recording
         *        Specifies whether the recorder is currently recording or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recording(Boolean recording);

        /**
         * <p>
         * The last (previous) status of the recorder.
         * </p>
         * 
         * @param lastStatus
         *        The last (previous) status of the recorder.
         * @see RecorderStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecorderStatus
         */
        Builder lastStatus(String lastStatus);

        /**
         * <p>
         * The last (previous) status of the recorder.
         * </p>
         * 
         * @param lastStatus
         *        The last (previous) status of the recorder.
         * @see RecorderStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecorderStatus
         */
        Builder lastStatus(RecorderStatus lastStatus);

        /**
         * <p>
         * The error code indicating that the recording failed.
         * </p>
         * 
         * @param lastErrorCode
         *        The error code indicating that the recording failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastErrorCode(String lastErrorCode);

        /**
         * <p>
         * The message indicating that the recording failed due to an error.
         * </p>
         * 
         * @param lastErrorMessage
         *        The message indicating that the recording failed due to an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastErrorMessage(String lastErrorMessage);

        /**
         * <p>
         * The time when the status was last changed.
         * </p>
         * 
         * @param lastStatusChangeTime
         *        The time when the status was last changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStatusChangeTime(Instant lastStatusChangeTime);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private Instant lastStartTime;

        private Instant lastStopTime;

        private Boolean recording;

        private String lastStatus;

        private String lastErrorCode;

        private String lastErrorMessage;

        private Instant lastStatusChangeTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationRecorderStatus model) {
            setName(model.name);
            setLastStartTime(model.lastStartTime);
            setLastStopTime(model.lastStopTime);
            setRecording(model.recording);
            setLastStatus(model.lastStatus);
            setLastErrorCode(model.lastErrorCode);
            setLastErrorMessage(model.lastErrorMessage);
            setLastStatusChangeTime(model.lastStatusChangeTime);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getLastStartTime() {
            return lastStartTime;
        }

        @Override
        public final Builder lastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
            return this;
        }

        public final void setLastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
        }

        public final Instant getLastStopTime() {
            return lastStopTime;
        }

        @Override
        public final Builder lastStopTime(Instant lastStopTime) {
            this.lastStopTime = lastStopTime;
            return this;
        }

        public final void setLastStopTime(Instant lastStopTime) {
            this.lastStopTime = lastStopTime;
        }

        public final Boolean getRecording() {
            return recording;
        }

        @Override
        public final Builder recording(Boolean recording) {
            this.recording = recording;
            return this;
        }

        public final void setRecording(Boolean recording) {
            this.recording = recording;
        }

        public final String getLastStatus() {
            return lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        @Override
        public final Builder lastStatus(RecorderStatus lastStatus) {
            this.lastStatus(lastStatus.toString());
            return this;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        public final void setLastStatus(RecorderStatus lastStatus) {
            this.lastStatus(lastStatus.toString());
        }

        public final String getLastErrorCode() {
            return lastErrorCode;
        }

        @Override
        public final Builder lastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
            return this;
        }

        public final void setLastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
        }

        public final String getLastErrorMessage() {
            return lastErrorMessage;
        }

        @Override
        public final Builder lastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
            return this;
        }

        public final void setLastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
        }

        public final Instant getLastStatusChangeTime() {
            return lastStatusChangeTime;
        }

        @Override
        public final Builder lastStatusChangeTime(Instant lastStatusChangeTime) {
            this.lastStatusChangeTime = lastStatusChangeTime;
            return this;
        }

        public final void setLastStatusChangeTime(Instant lastStatusChangeTime) {
            this.lastStatusChangeTime = lastStatusChangeTime;
        }

        @Override
        public ConfigurationRecorderStatus build() {
            return new ConfigurationRecorderStatus(this);
        }
    }
}
