/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeComplianceByConfigRuleResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeComplianceByConfigRuleResponse.Builder, DescribeComplianceByConfigRuleResponse> {
    private final List<ComplianceByConfigRule> complianceByConfigRules;

    private final String nextToken;

    private DescribeComplianceByConfigRuleResponse(BuilderImpl builder) {
        this.complianceByConfigRules = builder.complianceByConfigRules;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Indicates whether each of the specified AWS Config rules is compliant.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Indicates whether each of the specified AWS Config rules is compliant.
     */
    public List<ComplianceByConfigRule> complianceByConfigRules() {
        return complianceByConfigRules;
    }

    /**
     * <p>
     * The string that you use in a subsequent request to get the next page of results in a paginated response.
     * </p>
     * 
     * @return The string that you use in a subsequent request to get the next page of results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((complianceByConfigRules() == null) ? 0 : complianceByConfigRules().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComplianceByConfigRuleResponse)) {
            return false;
        }
        DescribeComplianceByConfigRuleResponse other = (DescribeComplianceByConfigRuleResponse) obj;
        if (other.complianceByConfigRules() == null ^ this.complianceByConfigRules() == null) {
            return false;
        }
        if (other.complianceByConfigRules() != null && !other.complianceByConfigRules().equals(this.complianceByConfigRules())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (complianceByConfigRules() != null) {
            sb.append("ComplianceByConfigRules: ").append(complianceByConfigRules()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeComplianceByConfigRuleResponse> {
        /**
         * <p>
         * Indicates whether each of the specified AWS Config rules is compliant.
         * </p>
         * 
         * @param complianceByConfigRules
         *        Indicates whether each of the specified AWS Config rules is compliant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceByConfigRules(Collection<ComplianceByConfigRule> complianceByConfigRules);

        /**
         * <p>
         * Indicates whether each of the specified AWS Config rules is compliant.
         * </p>
         * 
         * @param complianceByConfigRules
         *        Indicates whether each of the specified AWS Config rules is compliant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceByConfigRules(ComplianceByConfigRule... complianceByConfigRules);

        /**
         * <p>
         * The string that you use in a subsequent request to get the next page of results in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The string that you use in a subsequent request to get the next page of results in a paginated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<ComplianceByConfigRule> complianceByConfigRules;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComplianceByConfigRuleResponse model) {
            setComplianceByConfigRules(model.complianceByConfigRules);
            setNextToken(model.nextToken);
        }

        public final Collection<ComplianceByConfigRule> getComplianceByConfigRules() {
            return complianceByConfigRules;
        }

        @Override
        public final Builder complianceByConfigRules(Collection<ComplianceByConfigRule> complianceByConfigRules) {
            this.complianceByConfigRules = ComplianceByConfigRulesCopier.copy(complianceByConfigRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceByConfigRules(ComplianceByConfigRule... complianceByConfigRules) {
            complianceByConfigRules(Arrays.asList(complianceByConfigRules));
            return this;
        }

        public final void setComplianceByConfigRules(Collection<ComplianceByConfigRule> complianceByConfigRules) {
            this.complianceByConfigRules = ComplianceByConfigRulesCopier.copy(complianceByConfigRules);
        }

        @SafeVarargs
        public final void setComplianceByConfigRules(ComplianceByConfigRule... complianceByConfigRules) {
            complianceByConfigRules(Arrays.asList(complianceByConfigRules));
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeComplianceByConfigRuleResponse build() {
            return new DescribeComplianceByConfigRuleResponse(this);
        }
    }
}
