/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeComplianceByResourceResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeComplianceByResourceResponse.Builder, DescribeComplianceByResourceResponse> {
    private final List<ComplianceByResource> complianceByResources;

    private final String nextToken;

    private DescribeComplianceByResourceResponse(BuilderImpl builder) {
        this.complianceByResources = builder.complianceByResources;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Indicates whether the specified AWS resource complies with all of the AWS Config rules that evaluate it.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Indicates whether the specified AWS resource complies with all of the AWS Config rules that evaluate it.
     */
    public List<ComplianceByResource> complianceByResources() {
        return complianceByResources;
    }

    /**
     * <p>
     * The string that you use in a subsequent request to get the next page of results in a paginated response.
     * </p>
     * 
     * @return The string that you use in a subsequent request to get the next page of results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((complianceByResources() == null) ? 0 : complianceByResources().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComplianceByResourceResponse)) {
            return false;
        }
        DescribeComplianceByResourceResponse other = (DescribeComplianceByResourceResponse) obj;
        if (other.complianceByResources() == null ^ this.complianceByResources() == null) {
            return false;
        }
        if (other.complianceByResources() != null && !other.complianceByResources().equals(this.complianceByResources())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (complianceByResources() != null) {
            sb.append("ComplianceByResources: ").append(complianceByResources()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeComplianceByResourceResponse> {
        /**
         * <p>
         * Indicates whether the specified AWS resource complies with all of the AWS Config rules that evaluate it.
         * </p>
         * 
         * @param complianceByResources
         *        Indicates whether the specified AWS resource complies with all of the AWS Config rules that evaluate
         *        it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceByResources(Collection<ComplianceByResource> complianceByResources);

        /**
         * <p>
         * Indicates whether the specified AWS resource complies with all of the AWS Config rules that evaluate it.
         * </p>
         * 
         * @param complianceByResources
         *        Indicates whether the specified AWS resource complies with all of the AWS Config rules that evaluate
         *        it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceByResources(ComplianceByResource... complianceByResources);

        /**
         * <p>
         * The string that you use in a subsequent request to get the next page of results in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The string that you use in a subsequent request to get the next page of results in a paginated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<ComplianceByResource> complianceByResources;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComplianceByResourceResponse model) {
            setComplianceByResources(model.complianceByResources);
            setNextToken(model.nextToken);
        }

        public final Collection<ComplianceByResource> getComplianceByResources() {
            return complianceByResources;
        }

        @Override
        public final Builder complianceByResources(Collection<ComplianceByResource> complianceByResources) {
            this.complianceByResources = ComplianceByResourcesCopier.copy(complianceByResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceByResources(ComplianceByResource... complianceByResources) {
            complianceByResources(Arrays.asList(complianceByResources));
            return this;
        }

        public final void setComplianceByResources(Collection<ComplianceByResource> complianceByResources) {
            this.complianceByResources = ComplianceByResourcesCopier.copy(complianceByResources);
        }

        @SafeVarargs
        public final void setComplianceByResources(ComplianceByResource... complianceByResources) {
            complianceByResources(Arrays.asList(complianceByResources));
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeComplianceByResourceResponse build() {
            return new DescribeComplianceByResourceResponse(this);
        }
    }
}
