/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeConfigRuleEvaluationStatusResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeConfigRuleEvaluationStatusResponse.Builder, DescribeConfigRuleEvaluationStatusResponse> {
    private final List<ConfigRuleEvaluationStatus> configRulesEvaluationStatus;

    private final String nextToken;

    private DescribeConfigRuleEvaluationStatusResponse(BuilderImpl builder) {
        this.configRulesEvaluationStatus = builder.configRulesEvaluationStatus;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Status information about your AWS managed Config rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Status information about your AWS managed Config rules.
     */
    public List<ConfigRuleEvaluationStatus> configRulesEvaluationStatus() {
        return configRulesEvaluationStatus;
    }

    /**
     * <p>
     * The string that you use in a subsequent request to get the next page of results in a paginated response.
     * </p>
     * 
     * @return The string that you use in a subsequent request to get the next page of results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((configRulesEvaluationStatus() == null) ? 0 : configRulesEvaluationStatus().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigRuleEvaluationStatusResponse)) {
            return false;
        }
        DescribeConfigRuleEvaluationStatusResponse other = (DescribeConfigRuleEvaluationStatusResponse) obj;
        if (other.configRulesEvaluationStatus() == null ^ this.configRulesEvaluationStatus() == null) {
            return false;
        }
        if (other.configRulesEvaluationStatus() != null
                && !other.configRulesEvaluationStatus().equals(this.configRulesEvaluationStatus())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (configRulesEvaluationStatus() != null) {
            sb.append("ConfigRulesEvaluationStatus: ").append(configRulesEvaluationStatus()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeConfigRuleEvaluationStatusResponse> {
        /**
         * <p>
         * Status information about your AWS managed Config rules.
         * </p>
         * 
         * @param configRulesEvaluationStatus
         *        Status information about your AWS managed Config rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRulesEvaluationStatus(Collection<ConfigRuleEvaluationStatus> configRulesEvaluationStatus);

        /**
         * <p>
         * Status information about your AWS managed Config rules.
         * </p>
         * 
         * @param configRulesEvaluationStatus
         *        Status information about your AWS managed Config rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRulesEvaluationStatus(ConfigRuleEvaluationStatus... configRulesEvaluationStatus);

        /**
         * <p>
         * The string that you use in a subsequent request to get the next page of results in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The string that you use in a subsequent request to get the next page of results in a paginated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<ConfigRuleEvaluationStatus> configRulesEvaluationStatus;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigRuleEvaluationStatusResponse model) {
            setConfigRulesEvaluationStatus(model.configRulesEvaluationStatus);
            setNextToken(model.nextToken);
        }

        public final Collection<ConfigRuleEvaluationStatus> getConfigRulesEvaluationStatus() {
            return configRulesEvaluationStatus;
        }

        @Override
        public final Builder configRulesEvaluationStatus(Collection<ConfigRuleEvaluationStatus> configRulesEvaluationStatus) {
            this.configRulesEvaluationStatus = ConfigRuleEvaluationStatusListCopier.copy(configRulesEvaluationStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRulesEvaluationStatus(ConfigRuleEvaluationStatus... configRulesEvaluationStatus) {
            configRulesEvaluationStatus(Arrays.asList(configRulesEvaluationStatus));
            return this;
        }

        public final void setConfigRulesEvaluationStatus(Collection<ConfigRuleEvaluationStatus> configRulesEvaluationStatus) {
            this.configRulesEvaluationStatus = ConfigRuleEvaluationStatusListCopier.copy(configRulesEvaluationStatus);
        }

        @SafeVarargs
        public final void setConfigRulesEvaluationStatus(ConfigRuleEvaluationStatus... configRulesEvaluationStatus) {
            configRulesEvaluationStatus(Arrays.asList(configRulesEvaluationStatus));
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeConfigRuleEvaluationStatusResponse build() {
            return new DescribeConfigRuleEvaluationStatusResponse(this);
        }
    }
}
