/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>DescribeConfigurationRecorderStatus</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeConfigurationRecorderStatusRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeConfigurationRecorderStatusRequest.Builder, DescribeConfigurationRecorderStatusRequest> {
    private final List<String> configurationRecorderNames;

    private DescribeConfigurationRecorderStatusRequest(BuilderImpl builder) {
        this.configurationRecorderNames = builder.configurationRecorderNames;
    }

    /**
     * <p>
     * The name(s) of the configuration recorder. If the name is not specified, the action returns the current status of
     * all the configuration recorders associated with the account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The name(s) of the configuration recorder. If the name is not specified, the action returns the current
     *         status of all the configuration recorders associated with the account.
     */
    public List<String> configurationRecorderNames() {
        return configurationRecorderNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((configurationRecorderNames() == null) ? 0 : configurationRecorderNames().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationRecorderStatusRequest)) {
            return false;
        }
        DescribeConfigurationRecorderStatusRequest other = (DescribeConfigurationRecorderStatusRequest) obj;
        if (other.configurationRecorderNames() == null ^ this.configurationRecorderNames() == null) {
            return false;
        }
        if (other.configurationRecorderNames() != null
                && !other.configurationRecorderNames().equals(this.configurationRecorderNames())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (configurationRecorderNames() != null) {
            sb.append("ConfigurationRecorderNames: ").append(configurationRecorderNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeConfigurationRecorderStatusRequest> {
        /**
         * <p>
         * The name(s) of the configuration recorder. If the name is not specified, the action returns the current
         * status of all the configuration recorders associated with the account.
         * </p>
         * 
         * @param configurationRecorderNames
         *        The name(s) of the configuration recorder. If the name is not specified, the action returns the
         *        current status of all the configuration recorders associated with the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecorderNames(Collection<String> configurationRecorderNames);

        /**
         * <p>
         * The name(s) of the configuration recorder. If the name is not specified, the action returns the current
         * status of all the configuration recorders associated with the account.
         * </p>
         * 
         * @param configurationRecorderNames
         *        The name(s) of the configuration recorder. If the name is not specified, the action returns the
         *        current status of all the configuration recorders associated with the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecorderNames(String... configurationRecorderNames);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> configurationRecorderNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationRecorderStatusRequest model) {
            setConfigurationRecorderNames(model.configurationRecorderNames);
        }

        public final Collection<String> getConfigurationRecorderNames() {
            return configurationRecorderNames;
        }

        @Override
        public final Builder configurationRecorderNames(Collection<String> configurationRecorderNames) {
            this.configurationRecorderNames = ConfigurationRecorderNameListCopier.copy(configurationRecorderNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationRecorderNames(String... configurationRecorderNames) {
            configurationRecorderNames(Arrays.asList(configurationRecorderNames));
            return this;
        }

        public final void setConfigurationRecorderNames(Collection<String> configurationRecorderNames) {
            this.configurationRecorderNames = ConfigurationRecorderNameListCopier.copy(configurationRecorderNames);
        }

        @SafeVarargs
        public final void setConfigurationRecorderNames(String... configurationRecorderNames) {
            configurationRecorderNames(Arrays.asList(configurationRecorderNames));
        }

        @Override
        public DescribeConfigurationRecorderStatusRequest build() {
            return new DescribeConfigurationRecorderStatusRequest(this);
        }
    }
}
