/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the <a>DescribeConfigurationRecorders</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeConfigurationRecordersResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeConfigurationRecordersResponse.Builder, DescribeConfigurationRecordersResponse> {
    private final List<ConfigurationRecorder> configurationRecorders;

    private DescribeConfigurationRecordersResponse(BuilderImpl builder) {
        this.configurationRecorders = builder.configurationRecorders;
    }

    /**
     * <p>
     * A list that contains the descriptions of the specified configuration recorders.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list that contains the descriptions of the specified configuration recorders.
     */
    public List<ConfigurationRecorder> configurationRecorders() {
        return configurationRecorders;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((configurationRecorders() == null) ? 0 : configurationRecorders().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationRecordersResponse)) {
            return false;
        }
        DescribeConfigurationRecordersResponse other = (DescribeConfigurationRecordersResponse) obj;
        if (other.configurationRecorders() == null ^ this.configurationRecorders() == null) {
            return false;
        }
        if (other.configurationRecorders() != null && !other.configurationRecorders().equals(this.configurationRecorders())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (configurationRecorders() != null) {
            sb.append("ConfigurationRecorders: ").append(configurationRecorders()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeConfigurationRecordersResponse> {
        /**
         * <p>
         * A list that contains the descriptions of the specified configuration recorders.
         * </p>
         * 
         * @param configurationRecorders
         *        A list that contains the descriptions of the specified configuration recorders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecorders(Collection<ConfigurationRecorder> configurationRecorders);

        /**
         * <p>
         * A list that contains the descriptions of the specified configuration recorders.
         * </p>
         * 
         * @param configurationRecorders
         *        A list that contains the descriptions of the specified configuration recorders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecorders(ConfigurationRecorder... configurationRecorders);
    }

    private static final class BuilderImpl implements Builder {
        private List<ConfigurationRecorder> configurationRecorders;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationRecordersResponse model) {
            setConfigurationRecorders(model.configurationRecorders);
        }

        public final Collection<ConfigurationRecorder> getConfigurationRecorders() {
            return configurationRecorders;
        }

        @Override
        public final Builder configurationRecorders(Collection<ConfigurationRecorder> configurationRecorders) {
            this.configurationRecorders = ConfigurationRecorderListCopier.copy(configurationRecorders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationRecorders(ConfigurationRecorder... configurationRecorders) {
            configurationRecorders(Arrays.asList(configurationRecorders));
            return this;
        }

        public final void setConfigurationRecorders(Collection<ConfigurationRecorder> configurationRecorders) {
            this.configurationRecorders = ConfigurationRecorderListCopier.copy(configurationRecorders);
        }

        @SafeVarargs
        public final void setConfigurationRecorders(ConfigurationRecorder... configurationRecorders) {
            configurationRecorders(Arrays.asList(configurationRecorders));
        }

        @Override
        public DescribeConfigurationRecordersResponse build() {
            return new DescribeConfigurationRecordersResponse(this);
        }
    }
}
