/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.ScopeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines which resources trigger an evaluation for an AWS Config rule. The scope can include one or more resource
 * types, a combination of a tag key and value, or a combination of one resource type and one resource ID. Specify a
 * scope to constrain which resources trigger an evaluation for a rule. Otherwise, evaluations for the rule are
 * triggered when any resource in your recording group changes in configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Scope implements StructuredPojo, ToCopyableBuilder<Scope.Builder, Scope> {
    private final List<String> complianceResourceTypes;

    private final String tagKey;

    private final String tagValue;

    private final String complianceResourceId;

    private Scope(BuilderImpl builder) {
        this.complianceResourceTypes = builder.complianceResourceTypes;
        this.tagKey = builder.tagKey;
        this.tagValue = builder.tagValue;
        this.complianceResourceId = builder.complianceResourceId;
    }

    /**
     * <p>
     * The resource types of only those AWS resources that you want to trigger an evaluation for the rule. You can only
     * specify one type if you also specify a resource ID for <code>ComplianceResourceId</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The resource types of only those AWS resources that you want to trigger an evaluation for the rule. You
     *         can only specify one type if you also specify a resource ID for <code>ComplianceResourceId</code>.
     */
    public List<String> complianceResourceTypes() {
        return complianceResourceTypes;
    }

    /**
     * <p>
     * The tag key that is applied to only those AWS resources that you want you want to trigger an evaluation for the
     * rule.
     * </p>
     * 
     * @return The tag key that is applied to only those AWS resources that you want you want to trigger an evaluation
     *         for the rule.
     */
    public String tagKey() {
        return tagKey;
    }

    /**
     * <p>
     * The tag value applied to only those AWS resources that you want to trigger an evaluation for the rule. If you
     * specify a value for <code>TagValue</code>, you must also specify a value for <code>TagKey</code>.
     * </p>
     * 
     * @return The tag value applied to only those AWS resources that you want to trigger an evaluation for the rule. If
     *         you specify a value for <code>TagValue</code>, you must also specify a value for <code>TagKey</code>.
     */
    public String tagValue() {
        return tagValue;
    }

    /**
     * <p>
     * The IDs of the only AWS resource that you want to trigger an evaluation for the rule. If you specify a resource
     * ID, you must specify one resource type for <code>ComplianceResourceTypes</code>.
     * </p>
     * 
     * @return The IDs of the only AWS resource that you want to trigger an evaluation for the rule. If you specify a
     *         resource ID, you must specify one resource type for <code>ComplianceResourceTypes</code>.
     */
    public String complianceResourceId() {
        return complianceResourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((complianceResourceTypes() == null) ? 0 : complianceResourceTypes().hashCode());
        hashCode = 31 * hashCode + ((tagKey() == null) ? 0 : tagKey().hashCode());
        hashCode = 31 * hashCode + ((tagValue() == null) ? 0 : tagValue().hashCode());
        hashCode = 31 * hashCode + ((complianceResourceId() == null) ? 0 : complianceResourceId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scope)) {
            return false;
        }
        Scope other = (Scope) obj;
        if (other.complianceResourceTypes() == null ^ this.complianceResourceTypes() == null) {
            return false;
        }
        if (other.complianceResourceTypes() != null && !other.complianceResourceTypes().equals(this.complianceResourceTypes())) {
            return false;
        }
        if (other.tagKey() == null ^ this.tagKey() == null) {
            return false;
        }
        if (other.tagKey() != null && !other.tagKey().equals(this.tagKey())) {
            return false;
        }
        if (other.tagValue() == null ^ this.tagValue() == null) {
            return false;
        }
        if (other.tagValue() != null && !other.tagValue().equals(this.tagValue())) {
            return false;
        }
        if (other.complianceResourceId() == null ^ this.complianceResourceId() == null) {
            return false;
        }
        if (other.complianceResourceId() != null && !other.complianceResourceId().equals(this.complianceResourceId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (complianceResourceTypes() != null) {
            sb.append("ComplianceResourceTypes: ").append(complianceResourceTypes()).append(",");
        }
        if (tagKey() != null) {
            sb.append("TagKey: ").append(tagKey()).append(",");
        }
        if (tagValue() != null) {
            sb.append("TagValue: ").append(tagValue()).append(",");
        }
        if (complianceResourceId() != null) {
            sb.append("ComplianceResourceId: ").append(complianceResourceId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScopeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Scope> {
        /**
         * <p>
         * The resource types of only those AWS resources that you want to trigger an evaluation for the rule. You can
         * only specify one type if you also specify a resource ID for <code>ComplianceResourceId</code>.
         * </p>
         * 
         * @param complianceResourceTypes
         *        The resource types of only those AWS resources that you want to trigger an evaluation for the rule.
         *        You can only specify one type if you also specify a resource ID for <code>ComplianceResourceId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceResourceTypes(Collection<String> complianceResourceTypes);

        /**
         * <p>
         * The resource types of only those AWS resources that you want to trigger an evaluation for the rule. You can
         * only specify one type if you also specify a resource ID for <code>ComplianceResourceId</code>.
         * </p>
         * 
         * @param complianceResourceTypes
         *        The resource types of only those AWS resources that you want to trigger an evaluation for the rule.
         *        You can only specify one type if you also specify a resource ID for <code>ComplianceResourceId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceResourceTypes(String... complianceResourceTypes);

        /**
         * <p>
         * The tag key that is applied to only those AWS resources that you want you want to trigger an evaluation for
         * the rule.
         * </p>
         * 
         * @param tagKey
         *        The tag key that is applied to only those AWS resources that you want you want to trigger an
         *        evaluation for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKey(String tagKey);

        /**
         * <p>
         * The tag value applied to only those AWS resources that you want to trigger an evaluation for the rule. If you
         * specify a value for <code>TagValue</code>, you must also specify a value for <code>TagKey</code>.
         * </p>
         * 
         * @param tagValue
         *        The tag value applied to only those AWS resources that you want to trigger an evaluation for the rule.
         *        If you specify a value for <code>TagValue</code>, you must also specify a value for
         *        <code>TagKey</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValue(String tagValue);

        /**
         * <p>
         * The IDs of the only AWS resource that you want to trigger an evaluation for the rule. If you specify a
         * resource ID, you must specify one resource type for <code>ComplianceResourceTypes</code>.
         * </p>
         * 
         * @param complianceResourceId
         *        The IDs of the only AWS resource that you want to trigger an evaluation for the rule. If you specify a
         *        resource ID, you must specify one resource type for <code>ComplianceResourceTypes</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceResourceId(String complianceResourceId);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> complianceResourceTypes;

        private String tagKey;

        private String tagValue;

        private String complianceResourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(Scope model) {
            setComplianceResourceTypes(model.complianceResourceTypes);
            setTagKey(model.tagKey);
            setTagValue(model.tagValue);
            setComplianceResourceId(model.complianceResourceId);
        }

        public final Collection<String> getComplianceResourceTypes() {
            return complianceResourceTypes;
        }

        @Override
        public final Builder complianceResourceTypes(Collection<String> complianceResourceTypes) {
            this.complianceResourceTypes = ComplianceResourceTypesCopier.copy(complianceResourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceResourceTypes(String... complianceResourceTypes) {
            complianceResourceTypes(Arrays.asList(complianceResourceTypes));
            return this;
        }

        public final void setComplianceResourceTypes(Collection<String> complianceResourceTypes) {
            this.complianceResourceTypes = ComplianceResourceTypesCopier.copy(complianceResourceTypes);
        }

        @SafeVarargs
        public final void setComplianceResourceTypes(String... complianceResourceTypes) {
            complianceResourceTypes(Arrays.asList(complianceResourceTypes));
        }

        public final String getTagKey() {
            return tagKey;
        }

        @Override
        public final Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public final void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        public final String getTagValue() {
            return tagValue;
        }

        @Override
        public final Builder tagValue(String tagValue) {
            this.tagValue = tagValue;
            return this;
        }

        public final void setTagValue(String tagValue) {
            this.tagValue = tagValue;
        }

        public final String getComplianceResourceId() {
            return complianceResourceId;
        }

        @Override
        public final Builder complianceResourceId(String complianceResourceId) {
            this.complianceResourceId = complianceResourceId;
            return this;
        }

        public final void setComplianceResourceId(String complianceResourceId) {
            this.complianceResourceId = complianceResourceId;
        }

        @Override
        public Scope build() {
            return new Scope(this);
        }
    }
}
