/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.services.config.model.*;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * ConfigExportDeliveryInfoMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class ConfigExportDeliveryInfoMarshaller {

    private static final MarshallingInfo<String> LASTSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastStatus").build();
    private static final MarshallingInfo<String> LASTERRORCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastErrorCode").build();
    private static final MarshallingInfo<String> LASTERRORMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastErrorMessage").build();
    private static final MarshallingInfo<java.time.Instant> LASTATTEMPTTIME_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastAttemptTime")
            .build();
    private static final MarshallingInfo<java.time.Instant> LASTSUCCESSFULTIME_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("lastSuccessfulTime").build();
    private static final MarshallingInfo<java.time.Instant> NEXTDELIVERYTIME_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nextDeliveryTime")
            .build();

    private static final ConfigExportDeliveryInfoMarshaller instance = new ConfigExportDeliveryInfoMarshaller();

    public static ConfigExportDeliveryInfoMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(ConfigExportDeliveryInfo configExportDeliveryInfo, ProtocolMarshaller protocolMarshaller) {

        if (configExportDeliveryInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(configExportDeliveryInfo.lastStatus(), LASTSTATUS_BINDING);

            protocolMarshaller.marshall(configExportDeliveryInfo.lastErrorCode(), LASTERRORCODE_BINDING);

            protocolMarshaller.marshall(configExportDeliveryInfo.lastErrorMessage(), LASTERRORMESSAGE_BINDING);

            protocolMarshaller.marshall(configExportDeliveryInfo.lastAttemptTime(), LASTATTEMPTTIME_BINDING);

            protocolMarshaller.marshall(configExportDeliveryInfo.lastSuccessfulTime(), LASTSUCCESSFULTIME_BINDING);

            protocolMarshaller.marshall(configExportDeliveryInfo.nextDeliveryTime(), NEXTDELIVERYTIME_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
