/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.services.config.model.*;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * ConfigRuleEvaluationStatusMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class ConfigRuleEvaluationStatusMarshaller {

    private static final MarshallingInfo<String> CONFIGRULENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigRuleName").build();
    private static final MarshallingInfo<String> CONFIGRULEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigRuleArn").build();
    private static final MarshallingInfo<String> CONFIGRULEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigRuleId").build();
    private static final MarshallingInfo<java.time.Instant> LASTSUCCESSFULINVOCATIONTIME_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("LastSuccessfulInvocationTime").build();
    private static final MarshallingInfo<java.time.Instant> LASTFAILEDINVOCATIONTIME_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("LastFailedInvocationTime").build();
    private static final MarshallingInfo<java.time.Instant> LASTSUCCESSFULEVALUATIONTIME_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("LastSuccessfulEvaluationTime").build();
    private static final MarshallingInfo<java.time.Instant> LASTFAILEDEVALUATIONTIME_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("LastFailedEvaluationTime").build();
    private static final MarshallingInfo<java.time.Instant> FIRSTACTIVATEDTIME_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("FirstActivatedTime").build();
    private static final MarshallingInfo<String> LASTERRORCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastErrorCode").build();
    private static final MarshallingInfo<String> LASTERRORMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastErrorMessage").build();
    private static final MarshallingInfo<Boolean> FIRSTEVALUATIONSTARTED_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("FirstEvaluationStarted").build();

    private static final ConfigRuleEvaluationStatusMarshaller instance = new ConfigRuleEvaluationStatusMarshaller();

    public static ConfigRuleEvaluationStatusMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(ConfigRuleEvaluationStatus configRuleEvaluationStatus, ProtocolMarshaller protocolMarshaller) {

        if (configRuleEvaluationStatus == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(configRuleEvaluationStatus.configRuleName(), CONFIGRULENAME_BINDING);

            protocolMarshaller.marshall(configRuleEvaluationStatus.configRuleArn(), CONFIGRULEARN_BINDING);

            protocolMarshaller.marshall(configRuleEvaluationStatus.configRuleId(), CONFIGRULEID_BINDING);

            protocolMarshaller.marshall(configRuleEvaluationStatus.lastSuccessfulInvocationTime(),
                    LASTSUCCESSFULINVOCATIONTIME_BINDING);

            protocolMarshaller.marshall(configRuleEvaluationStatus.lastFailedInvocationTime(), LASTFAILEDINVOCATIONTIME_BINDING);

            protocolMarshaller.marshall(configRuleEvaluationStatus.lastSuccessfulEvaluationTime(),
                    LASTSUCCESSFULEVALUATIONTIME_BINDING);

            protocolMarshaller.marshall(configRuleEvaluationStatus.lastFailedEvaluationTime(), LASTFAILEDEVALUATIONTIME_BINDING);

            protocolMarshaller.marshall(configRuleEvaluationStatus.firstActivatedTime(), FIRSTACTIVATEDTIME_BINDING);

            protocolMarshaller.marshall(configRuleEvaluationStatus.lastErrorCode(), LASTERRORCODE_BINDING);

            protocolMarshaller.marshall(configRuleEvaluationStatus.lastErrorMessage(), LASTERRORMESSAGE_BINDING);

            protocolMarshaller.marshall(configRuleEvaluationStatus.firstEvaluationStarted(), FIRSTEVALUATIONSTARTED_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
