/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.config.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ConfigRuleEvaluationStatus JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ConfigRuleEvaluationStatusUnmarshaller implements Unmarshaller<ConfigRuleEvaluationStatus, JsonUnmarshallerContext> {

    public ConfigRuleEvaluationStatus unmarshall(JsonUnmarshallerContext context) throws Exception {
        ConfigRuleEvaluationStatus.Builder configRuleEvaluationStatusBuilder = ConfigRuleEvaluationStatus.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("ConfigRuleName", targetDepth)) {
                    context.nextToken();
                    configRuleEvaluationStatusBuilder.configRuleName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ConfigRuleArn", targetDepth)) {
                    context.nextToken();
                    configRuleEvaluationStatusBuilder.configRuleArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ConfigRuleId", targetDepth)) {
                    context.nextToken();
                    configRuleEvaluationStatusBuilder.configRuleId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LastSuccessfulInvocationTime", targetDepth)) {
                    context.nextToken();
                    configRuleEvaluationStatusBuilder.lastSuccessfulInvocationTime(context.getUnmarshaller(
                            java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("LastFailedInvocationTime", targetDepth)) {
                    context.nextToken();
                    configRuleEvaluationStatusBuilder.lastFailedInvocationTime(context.getUnmarshaller(java.time.Instant.class)
                            .unmarshall(context));
                }
                if (context.testExpression("LastSuccessfulEvaluationTime", targetDepth)) {
                    context.nextToken();
                    configRuleEvaluationStatusBuilder.lastSuccessfulEvaluationTime(context.getUnmarshaller(
                            java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("LastFailedEvaluationTime", targetDepth)) {
                    context.nextToken();
                    configRuleEvaluationStatusBuilder.lastFailedEvaluationTime(context.getUnmarshaller(java.time.Instant.class)
                            .unmarshall(context));
                }
                if (context.testExpression("FirstActivatedTime", targetDepth)) {
                    context.nextToken();
                    configRuleEvaluationStatusBuilder.firstActivatedTime(context.getUnmarshaller(java.time.Instant.class)
                            .unmarshall(context));
                }
                if (context.testExpression("LastErrorCode", targetDepth)) {
                    context.nextToken();
                    configRuleEvaluationStatusBuilder.lastErrorCode(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LastErrorMessage", targetDepth)) {
                    context.nextToken();
                    configRuleEvaluationStatusBuilder.lastErrorMessage(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("FirstEvaluationStarted", targetDepth)) {
                    context.nextToken();
                    configRuleEvaluationStatusBuilder.firstEvaluationStarted(context.getUnmarshaller(Boolean.class).unmarshall(
                            context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return configRuleEvaluationStatusBuilder.build();
    }

    private static ConfigRuleEvaluationStatusUnmarshaller INSTANCE;

    public static ConfigRuleEvaluationStatusUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new ConfigRuleEvaluationStatusUnmarshaller();
        return INSTANCE;
    }
}
