/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.config.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * EvaluationResult JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class EvaluationResultUnmarshaller implements Unmarshaller<EvaluationResult, JsonUnmarshallerContext> {

    public EvaluationResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        EvaluationResult.Builder evaluationResultBuilder = EvaluationResult.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("EvaluationResultIdentifier", targetDepth)) {
                    context.nextToken();
                    evaluationResultBuilder.evaluationResultIdentifier(EvaluationResultIdentifierUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("ComplianceType", targetDepth)) {
                    context.nextToken();
                    evaluationResultBuilder.complianceType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ResultRecordedTime", targetDepth)) {
                    context.nextToken();
                    evaluationResultBuilder.resultRecordedTime(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("ConfigRuleInvokedTime", targetDepth)) {
                    context.nextToken();
                    evaluationResultBuilder.configRuleInvokedTime(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("Annotation", targetDepth)) {
                    context.nextToken();
                    evaluationResultBuilder.annotation(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ResultToken", targetDepth)) {
                    context.nextToken();
                    evaluationResultBuilder.resultToken(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return evaluationResultBuilder.build();
    }

    private static EvaluationResultUnmarshaller INSTANCE;

    public static EvaluationResultUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new EvaluationResultUnmarshaller();
        return INSTANCE;
    }
}
