/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ComplianceType;
import software.amazon.awssdk.services.config.transform.EvaluationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Evaluation
implements StructuredPojo,
ToCopyableBuilder<Builder, Evaluation> {
    private final String complianceResourceType;
    private final String complianceResourceId;
    private final String complianceType;
    private final String annotation;
    private final Instant orderingTimestamp;

    private Evaluation(BuilderImpl builder) {
        this.complianceResourceType = builder.complianceResourceType;
        this.complianceResourceId = builder.complianceResourceId;
        this.complianceType = builder.complianceType;
        this.annotation = builder.annotation;
        this.orderingTimestamp = builder.orderingTimestamp;
    }

    public String complianceResourceType() {
        return this.complianceResourceType;
    }

    public String complianceResourceId() {
        return this.complianceResourceId;
    }

    public String complianceType() {
        return this.complianceType;
    }

    public String annotation() {
        return this.annotation;
    }

    public Instant orderingTimestamp() {
        return this.orderingTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.complianceResourceType() == null ? 0 : this.complianceResourceType().hashCode());
        hashCode = 31 * hashCode + (this.complianceResourceId() == null ? 0 : this.complianceResourceId().hashCode());
        hashCode = 31 * hashCode + (this.complianceType() == null ? 0 : this.complianceType().hashCode());
        hashCode = 31 * hashCode + (this.annotation() == null ? 0 : this.annotation().hashCode());
        hashCode = 31 * hashCode + (this.orderingTimestamp() == null ? 0 : this.orderingTimestamp().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Evaluation)) {
            return false;
        }
        Evaluation other = (Evaluation)obj;
        if (other.complianceResourceType() == null ^ this.complianceResourceType() == null) {
            return false;
        }
        if (other.complianceResourceType() != null && !other.complianceResourceType().equals(this.complianceResourceType())) {
            return false;
        }
        if (other.complianceResourceId() == null ^ this.complianceResourceId() == null) {
            return false;
        }
        if (other.complianceResourceId() != null && !other.complianceResourceId().equals(this.complianceResourceId())) {
            return false;
        }
        if (other.complianceType() == null ^ this.complianceType() == null) {
            return false;
        }
        if (other.complianceType() != null && !other.complianceType().equals(this.complianceType())) {
            return false;
        }
        if (other.annotation() == null ^ this.annotation() == null) {
            return false;
        }
        if (other.annotation() != null && !other.annotation().equals(this.annotation())) {
            return false;
        }
        if (other.orderingTimestamp() == null ^ this.orderingTimestamp() == null) {
            return false;
        }
        return other.orderingTimestamp() == null || other.orderingTimestamp().equals(this.orderingTimestamp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.complianceResourceType() != null) {
            sb.append("ComplianceResourceType: ").append(this.complianceResourceType()).append(",");
        }
        if (this.complianceResourceId() != null) {
            sb.append("ComplianceResourceId: ").append(this.complianceResourceId()).append(",");
        }
        if (this.complianceType() != null) {
            sb.append("ComplianceType: ").append(this.complianceType()).append(",");
        }
        if (this.annotation() != null) {
            sb.append("Annotation: ").append(this.annotation()).append(",");
        }
        if (this.orderingTimestamp() != null) {
            sb.append("OrderingTimestamp: ").append(this.orderingTimestamp()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EvaluationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String complianceResourceType;
        private String complianceResourceId;
        private String complianceType;
        private String annotation;
        private Instant orderingTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Evaluation model) {
            this.setComplianceResourceType(model.complianceResourceType);
            this.setComplianceResourceId(model.complianceResourceId);
            this.setComplianceType(model.complianceType);
            this.setAnnotation(model.annotation);
            this.setOrderingTimestamp(model.orderingTimestamp);
        }

        public final String getComplianceResourceType() {
            return this.complianceResourceType;
        }

        @Override
        public final Builder complianceResourceType(String complianceResourceType) {
            this.complianceResourceType = complianceResourceType;
            return this;
        }

        public final void setComplianceResourceType(String complianceResourceType) {
            this.complianceResourceType = complianceResourceType;
        }

        public final String getComplianceResourceId() {
            return this.complianceResourceId;
        }

        @Override
        public final Builder complianceResourceId(String complianceResourceId) {
            this.complianceResourceId = complianceResourceId;
            return this;
        }

        public final void setComplianceResourceId(String complianceResourceId) {
            this.complianceResourceId = complianceResourceId;
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ComplianceType complianceType) {
            this.complianceType(complianceType.toString());
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final void setComplianceType(ComplianceType complianceType) {
            this.complianceType(complianceType.toString());
        }

        public final String getAnnotation() {
            return this.annotation;
        }

        @Override
        public final Builder annotation(String annotation) {
            this.annotation = annotation;
            return this;
        }

        public final void setAnnotation(String annotation) {
            this.annotation = annotation;
        }

        public final Instant getOrderingTimestamp() {
            return this.orderingTimestamp;
        }

        @Override
        public final Builder orderingTimestamp(Instant orderingTimestamp) {
            this.orderingTimestamp = orderingTimestamp;
            return this;
        }

        public final void setOrderingTimestamp(Instant orderingTimestamp) {
            this.orderingTimestamp = orderingTimestamp;
        }

        public Evaluation build() {
            return new Evaluation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Evaluation> {
        public Builder complianceResourceType(String var1);

        public Builder complianceResourceId(String var1);

        public Builder complianceType(String var1);

        public Builder complianceType(ComplianceType var1);

        public Builder annotation(String var1);

        public Builder orderingTimestamp(Instant var1);
    }
}

