/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.config.model.ChronologicalOrder;
import software.amazon.awssdk.services.config.model.ResourceType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetResourceConfigHistoryRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetResourceConfigHistoryRequest> {
    private final String resourceType;
    private final String resourceId;
    private final Instant laterTime;
    private final Instant earlierTime;
    private final String chronologicalOrder;
    private final Integer limit;
    private final String nextToken;

    private GetResourceConfigHistoryRequest(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.laterTime = builder.laterTime;
        this.earlierTime = builder.earlierTime;
        this.chronologicalOrder = builder.chronologicalOrder;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public Instant laterTime() {
        return this.laterTime;
    }

    public Instant earlierTime() {
        return this.earlierTime;
    }

    public String chronologicalOrder() {
        return this.chronologicalOrder;
    }

    public Integer limit() {
        return this.limit;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceType() == null ? 0 : this.resourceType().hashCode());
        hashCode = 31 * hashCode + (this.resourceId() == null ? 0 : this.resourceId().hashCode());
        hashCode = 31 * hashCode + (this.laterTime() == null ? 0 : this.laterTime().hashCode());
        hashCode = 31 * hashCode + (this.earlierTime() == null ? 0 : this.earlierTime().hashCode());
        hashCode = 31 * hashCode + (this.chronologicalOrder() == null ? 0 : this.chronologicalOrder().hashCode());
        hashCode = 31 * hashCode + (this.limit() == null ? 0 : this.limit().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceConfigHistoryRequest)) {
            return false;
        }
        GetResourceConfigHistoryRequest other = (GetResourceConfigHistoryRequest)((Object)obj);
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.laterTime() == null ^ this.laterTime() == null) {
            return false;
        }
        if (other.laterTime() != null && !other.laterTime().equals(this.laterTime())) {
            return false;
        }
        if (other.earlierTime() == null ^ this.earlierTime() == null) {
            return false;
        }
        if (other.earlierTime() != null && !other.earlierTime().equals(this.earlierTime())) {
            return false;
        }
        if (other.chronologicalOrder() == null ^ this.chronologicalOrder() == null) {
            return false;
        }
        if (other.chronologicalOrder() != null && !other.chronologicalOrder().equals(this.chronologicalOrder())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resourceType() != null) {
            sb.append("ResourceType: ").append(this.resourceType()).append(",");
        }
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (this.laterTime() != null) {
            sb.append("LaterTime: ").append(this.laterTime()).append(",");
        }
        if (this.earlierTime() != null) {
            sb.append("EarlierTime: ").append(this.earlierTime()).append(",");
        }
        if (this.chronologicalOrder() != null) {
            sb.append("ChronologicalOrder: ").append(this.chronologicalOrder()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private String resourceId;
        private Instant laterTime;
        private Instant earlierTime;
        private String chronologicalOrder;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceConfigHistoryRequest model) {
            this.setResourceType(model.resourceType);
            this.setResourceId(model.resourceId);
            this.setLaterTime(model.laterTime);
            this.setEarlierTime(model.earlierTime);
            this.setChronologicalOrder(model.chronologicalOrder);
            this.setLimit(model.limit);
            this.setNextToken(model.nextToken);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final void setResourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Instant getLaterTime() {
            return this.laterTime;
        }

        @Override
        public final Builder laterTime(Instant laterTime) {
            this.laterTime = laterTime;
            return this;
        }

        public final void setLaterTime(Instant laterTime) {
            this.laterTime = laterTime;
        }

        public final Instant getEarlierTime() {
            return this.earlierTime;
        }

        @Override
        public final Builder earlierTime(Instant earlierTime) {
            this.earlierTime = earlierTime;
            return this;
        }

        public final void setEarlierTime(Instant earlierTime) {
            this.earlierTime = earlierTime;
        }

        public final String getChronologicalOrder() {
            return this.chronologicalOrder;
        }

        @Override
        public final Builder chronologicalOrder(String chronologicalOrder) {
            this.chronologicalOrder = chronologicalOrder;
            return this;
        }

        @Override
        public final Builder chronologicalOrder(ChronologicalOrder chronologicalOrder) {
            this.chronologicalOrder(chronologicalOrder.toString());
            return this;
        }

        public final void setChronologicalOrder(String chronologicalOrder) {
            this.chronologicalOrder = chronologicalOrder;
        }

        public final void setChronologicalOrder(ChronologicalOrder chronologicalOrder) {
            this.chronologicalOrder(chronologicalOrder.toString());
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public GetResourceConfigHistoryRequest build() {
            return new GetResourceConfigHistoryRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetResourceConfigHistoryRequest> {
        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceId(String var1);

        public Builder laterTime(Instant var1);

        public Builder earlierTime(Instant var1);

        public Builder chronologicalOrder(String var1);

        public Builder chronologicalOrder(ChronologicalOrder var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);
    }
}

