/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.config.model.ConfigRuleNamesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeConfigRuleEvaluationStatusRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeConfigRuleEvaluationStatusRequest> {
    private final List<String> configRuleNames;
    private final String nextToken;
    private final Integer limit;

    private DescribeConfigRuleEvaluationStatusRequest(BuilderImpl builder) {
        this.configRuleNames = builder.configRuleNames;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    public List<String> configRuleNames() {
        return this.configRuleNames;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer limit() {
        return this.limit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.configRuleNames() == null ? 0 : this.configRuleNames().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.limit() == null ? 0 : this.limit().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigRuleEvaluationStatusRequest)) {
            return false;
        }
        DescribeConfigRuleEvaluationStatusRequest other = (DescribeConfigRuleEvaluationStatusRequest)((Object)obj);
        if (other.configRuleNames() == null ^ this.configRuleNames() == null) {
            return false;
        }
        if (other.configRuleNames() != null && !other.configRuleNames().equals(this.configRuleNames())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        return other.limit() == null || other.limit().equals(this.limit());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configRuleNames() != null) {
            sb.append("ConfigRuleNames: ").append(this.configRuleNames()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> configRuleNames;
        private String nextToken;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigRuleEvaluationStatusRequest model) {
            this.setConfigRuleNames(model.configRuleNames);
            this.setNextToken(model.nextToken);
            this.setLimit(model.limit);
        }

        public final Collection<String> getConfigRuleNames() {
            return this.configRuleNames;
        }

        @Override
        public final Builder configRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConfigRuleNamesCopier.copy(configRuleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRuleNames(String ... configRuleNames) {
            this.configRuleNames(Arrays.asList(configRuleNames));
            return this;
        }

        public final void setConfigRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConfigRuleNamesCopier.copy(configRuleNames);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public DescribeConfigRuleEvaluationStatusRequest build() {
            return new DescribeConfigRuleEvaluationStatusRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeConfigRuleEvaluationStatusRequest> {
        public Builder configRuleNames(Collection<String> var1);

        public Builder configRuleNames(String ... var1);

        public Builder nextToken(String var1);

        public Builder limit(Integer var1);
    }
}

