/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.config.model.ConfigurationItem;
import software.amazon.awssdk.services.config.model.ConfigurationItemListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetResourceConfigHistoryResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetResourceConfigHistoryResponse> {
    private final List<ConfigurationItem> configurationItems;
    private final String nextToken;

    private GetResourceConfigHistoryResponse(BuilderImpl builder) {
        this.configurationItems = builder.configurationItems;
        this.nextToken = builder.nextToken;
    }

    public List<ConfigurationItem> configurationItems() {
        return this.configurationItems;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.configurationItems() == null ? 0 : this.configurationItems().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceConfigHistoryResponse)) {
            return false;
        }
        GetResourceConfigHistoryResponse other = (GetResourceConfigHistoryResponse)((Object)obj);
        if (other.configurationItems() == null ^ this.configurationItems() == null) {
            return false;
        }
        if (other.configurationItems() != null && !other.configurationItems().equals(this.configurationItems())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configurationItems() != null) {
            sb.append("ConfigurationItems: ").append(this.configurationItems()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ConfigurationItem> configurationItems;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceConfigHistoryResponse model) {
            this.setConfigurationItems(model.configurationItems);
            this.setNextToken(model.nextToken);
        }

        public final Collection<ConfigurationItem> getConfigurationItems() {
            return this.configurationItems;
        }

        @Override
        public final Builder configurationItems(Collection<ConfigurationItem> configurationItems) {
            this.configurationItems = ConfigurationItemListCopier.copy(configurationItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationItems(ConfigurationItem ... configurationItems) {
            this.configurationItems(Arrays.asList(configurationItems));
            return this;
        }

        public final void setConfigurationItems(Collection<ConfigurationItem> configurationItems) {
            this.configurationItems = ConfigurationItemListCopier.copy(configurationItems);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public GetResourceConfigHistoryResponse build() {
            return new GetResourceConfigHistoryResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetResourceConfigHistoryResponse> {
        public Builder configurationItems(Collection<ConfigurationItem> var1);

        public Builder configurationItems(ConfigurationItem ... var1);

        public Builder nextToken(String var1);
    }
}

