/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.EventSource;
import software.amazon.awssdk.services.config.model.MaximumExecutionFrequency;
import software.amazon.awssdk.services.config.model.MessageType;
import software.amazon.awssdk.services.config.transform.SourceDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SourceDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, SourceDetail> {
    private final String eventSource;
    private final String messageType;
    private final String maximumExecutionFrequency;

    private SourceDetail(BuilderImpl builder) {
        this.eventSource = builder.eventSource;
        this.messageType = builder.messageType;
        this.maximumExecutionFrequency = builder.maximumExecutionFrequency;
    }

    public String eventSource() {
        return this.eventSource;
    }

    public String messageType() {
        return this.messageType;
    }

    public String maximumExecutionFrequency() {
        return this.maximumExecutionFrequency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.eventSource() == null ? 0 : this.eventSource().hashCode());
        hashCode = 31 * hashCode + (this.messageType() == null ? 0 : this.messageType().hashCode());
        hashCode = 31 * hashCode + (this.maximumExecutionFrequency() == null ? 0 : this.maximumExecutionFrequency().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceDetail)) {
            return false;
        }
        SourceDetail other = (SourceDetail)obj;
        if (other.eventSource() == null ^ this.eventSource() == null) {
            return false;
        }
        if (other.eventSource() != null && !other.eventSource().equals(this.eventSource())) {
            return false;
        }
        if (other.messageType() == null ^ this.messageType() == null) {
            return false;
        }
        if (other.messageType() != null && !other.messageType().equals(this.messageType())) {
            return false;
        }
        if (other.maximumExecutionFrequency() == null ^ this.maximumExecutionFrequency() == null) {
            return false;
        }
        return other.maximumExecutionFrequency() == null || other.maximumExecutionFrequency().equals(this.maximumExecutionFrequency());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.eventSource() != null) {
            sb.append("EventSource: ").append(this.eventSource()).append(",");
        }
        if (this.messageType() != null) {
            sb.append("MessageType: ").append(this.messageType()).append(",");
        }
        if (this.maximumExecutionFrequency() != null) {
            sb.append("MaximumExecutionFrequency: ").append(this.maximumExecutionFrequency()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SourceDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String eventSource;
        private String messageType;
        private String maximumExecutionFrequency;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceDetail model) {
            this.setEventSource(model.eventSource);
            this.setMessageType(model.messageType);
            this.setMaximumExecutionFrequency(model.maximumExecutionFrequency);
        }

        public final String getEventSource() {
            return this.eventSource;
        }

        @Override
        public final Builder eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        @Override
        public final Builder eventSource(EventSource eventSource) {
            this.eventSource(eventSource.toString());
            return this;
        }

        public final void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        public final String getMessageType() {
            return this.messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType.toString());
            return this;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        public final String getMaximumExecutionFrequency() {
            return this.maximumExecutionFrequency;
        }

        @Override
        public final Builder maximumExecutionFrequency(String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
            return this;
        }

        @Override
        public final Builder maximumExecutionFrequency(MaximumExecutionFrequency maximumExecutionFrequency) {
            this.maximumExecutionFrequency(maximumExecutionFrequency.toString());
            return this;
        }

        public final void setMaximumExecutionFrequency(String maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
        }

        public SourceDetail build() {
            return new SourceDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SourceDetail> {
        public Builder eventSource(String var1);

        public Builder eventSource(EventSource var1);

        public Builder messageType(String var1);

        public Builder messageType(MessageType var1);

        public Builder maximumExecutionFrequency(String var1);

        public Builder maximumExecutionFrequency(MaximumExecutionFrequency var1);
    }
}

