/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.config.model.ComplianceSummary;
import software.amazon.awssdk.services.config.transform.ComplianceContributorCountUnmarshaller;

public class ComplianceSummaryUnmarshaller
implements Unmarshaller<ComplianceSummary, JsonUnmarshallerContext> {
    private static final ComplianceSummaryUnmarshaller INSTANCE = new ComplianceSummaryUnmarshaller();

    public ComplianceSummary unmarshall(JsonUnmarshallerContext context) throws Exception {
        ComplianceSummary.Builder complianceSummaryBuilder = ComplianceSummary.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("CompliantResourceCount", targetDepth)) {
                    context.nextToken();
                    complianceSummaryBuilder.compliantResourceCount(ComplianceContributorCountUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("NonCompliantResourceCount", targetDepth)) {
                    context.nextToken();
                    complianceSummaryBuilder.nonCompliantResourceCount(ComplianceContributorCountUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ComplianceSummaryTimestamp", targetDepth)) {
                    context.nextToken();
                    complianceSummaryBuilder.complianceSummaryTimestamp((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ComplianceSummary)complianceSummaryBuilder.build();
    }

    public static ComplianceSummaryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

