/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.SdkClientHandler;
import software.amazon.awssdk.config.ClientConfiguration;
import software.amazon.awssdk.config.SyncClientConfiguration;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.services.config.model.ConfigException;
import software.amazon.awssdk.services.config.model.DeleteConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.DeleteDeliveryChannelRequest;
import software.amazon.awssdk.services.config.model.DeleteDeliveryChannelResponse;
import software.amazon.awssdk.services.config.model.DeleteEvaluationResultsRequest;
import software.amazon.awssdk.services.config.model.DeleteEvaluationResultsResponse;
import software.amazon.awssdk.services.config.model.DeliverConfigSnapshotRequest;
import software.amazon.awssdk.services.config.model.DeliverConfigSnapshotResponse;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersResponse;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsRequest;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsResponse;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceResponse;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeRequest;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeResponse;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse;
import software.amazon.awssdk.services.config.model.InsufficientDeliveryPolicyException;
import software.amazon.awssdk.services.config.model.InsufficientPermissionsException;
import software.amazon.awssdk.services.config.model.InvalidConfigurationRecorderNameException;
import software.amazon.awssdk.services.config.model.InvalidDeliveryChannelNameException;
import software.amazon.awssdk.services.config.model.InvalidLimitException;
import software.amazon.awssdk.services.config.model.InvalidNextTokenException;
import software.amazon.awssdk.services.config.model.InvalidParameterValueException;
import software.amazon.awssdk.services.config.model.InvalidRecordingGroupException;
import software.amazon.awssdk.services.config.model.InvalidResultTokenException;
import software.amazon.awssdk.services.config.model.InvalidRoleException;
import software.amazon.awssdk.services.config.model.InvalidS3KeyPrefixException;
import software.amazon.awssdk.services.config.model.InvalidSNSTopicARNException;
import software.amazon.awssdk.services.config.model.InvalidTimeRangeException;
import software.amazon.awssdk.services.config.model.LastDeliveryChannelDeleteFailedException;
import software.amazon.awssdk.services.config.model.LimitExceededException;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesResponse;
import software.amazon.awssdk.services.config.model.MaxNumberOfConfigRulesExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfConfigurationRecordersExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfDeliveryChannelsExceededException;
import software.amazon.awssdk.services.config.model.NoAvailableConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoAvailableDeliveryChannelException;
import software.amazon.awssdk.services.config.model.NoRunningConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoSuchBucketException;
import software.amazon.awssdk.services.config.model.NoSuchConfigRuleException;
import software.amazon.awssdk.services.config.model.NoSuchConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoSuchDeliveryChannelException;
import software.amazon.awssdk.services.config.model.PutConfigRuleRequest;
import software.amazon.awssdk.services.config.model.PutConfigRuleResponse;
import software.amazon.awssdk.services.config.model.PutConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.PutConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.PutDeliveryChannelRequest;
import software.amazon.awssdk.services.config.model.PutDeliveryChannelResponse;
import software.amazon.awssdk.services.config.model.PutEvaluationsRequest;
import software.amazon.awssdk.services.config.model.PutEvaluationsResponse;
import software.amazon.awssdk.services.config.model.ResourceInUseException;
import software.amazon.awssdk.services.config.model.ResourceNotDiscoveredException;
import software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationRequest;
import software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationResponse;
import software.amazon.awssdk.services.config.model.StartConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.StartConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.StopConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.StopConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.ValidationException;
import software.amazon.awssdk.services.config.transform.DeleteConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigRuleResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigurationRecorderResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DeleteDeliveryChannelRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteDeliveryChannelResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DeleteEvaluationResultsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteEvaluationResultsResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DeliverConfigSnapshotRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeliverConfigSnapshotResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DescribeComplianceByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeComplianceByConfigRuleResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DescribeComplianceByResourceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeComplianceByResourceResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigRuleEvaluationStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigRuleEvaluationStatusResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigRulesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigRulesResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationRecorderStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationRecorderStatusResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationRecordersRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationRecordersResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DescribeDeliveryChannelStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeDeliveryChannelStatusResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.DescribeDeliveryChannelsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeDeliveryChannelsResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceDetailsByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceDetailsByConfigRuleResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceDetailsByResourceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceDetailsByResourceResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceSummaryByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceSummaryByConfigRuleResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceSummaryByResourceTypeRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceSummaryByResourceTypeResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.GetResourceConfigHistoryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetResourceConfigHistoryResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.ListDiscoveredResourcesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListDiscoveredResourcesResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigRuleResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigurationRecorderResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.PutDeliveryChannelRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutDeliveryChannelResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.PutEvaluationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutEvaluationsResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.StartConfigRulesEvaluationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StartConfigRulesEvaluationResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.StartConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StartConfigurationRecorderResponseUnmarshaller;
import software.amazon.awssdk.services.config.transform.StopConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StopConfigurationRecorderResponseUnmarshaller;

/**
 * Internal implementation of {@link ConfigClient}.
 *
 * @see ConfigClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultConfigClient implements ConfigClient {
    private final ClientHandler clientHandler;

    private final SdkJsonProtocolFactory protocolFactory;

    private final ClientConfiguration clientConfiguration;

    protected DefaultConfigClient(SyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkClientHandler(clientConfiguration, null);
        this.protocolFactory = init();
        this.clientConfiguration = clientConfiguration;
    }

    /**
     * <p>
     * Deletes the specified AWS Config rule and all of its evaluation results.
     * </p>
     * <p>
     * AWS Config sets the state of a rule to <code>DELETING</code> until the deletion is complete. You cannot update a
     * rule while it is in this state. If you make a <code>PutConfigRule</code> or <code>DeleteConfigRule</code> request
     * for the rule, you will receive a <code>ResourceInUseException</code>.
     * </p>
     * <p>
     * You can check the state of a rule by using the <code>DescribeConfigRules</code> request.
     * </p>
     *
     * @param deleteConfigRuleRequest
     * @return Result of the DeleteConfigRule operation returned by the service.
     * @throws NoSuchConfigRuleException
     *         One or more AWS Config rules in the request are invalid. Verify that the rule names are correct and try
     *         again.
     * @throws ResourceInUseException
     *         The rule is currently being deleted or the rule is deleting your evaluation results. Try your request
     *         again later.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteConfigRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigRule" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteConfigRuleResponse deleteConfigRule(DeleteConfigRuleRequest deleteConfigRuleRequest)
            throws NoSuchConfigRuleException, ResourceInUseException, SdkBaseException, SdkClientException, ConfigException {

        HttpResponseHandler<DeleteConfigRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteConfigRuleResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteConfigRuleRequest, DeleteConfigRuleResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteConfigRuleRequest).withMarshaller(new DeleteConfigRuleRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes the configuration recorder.
     * </p>
     * <p>
     * After the configuration recorder is deleted, AWS Config will not record resource configuration changes until you
     * create a new configuration recorder.
     * </p>
     * <p>
     * This action does not delete the configuration information that was previously recorded. You will be able to
     * access the previously recorded information by using the <code>GetResourceConfigHistory</code> action, but you
     * will not be able to access this information in the AWS Config console until you create a new configuration
     * recorder.
     * </p>
     *
     * @param deleteConfigurationRecorderRequest
     *        The request object for the <code>DeleteConfigurationRecorder</code> action.
     * @return Result of the DeleteConfigurationRecorder operation returned by the service.
     * @throws NoSuchConfigurationRecorderException
     *         You have specified a configuration recorder that does not exist.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteConfigurationRecorder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteConfigurationRecorderResponse deleteConfigurationRecorder(
            DeleteConfigurationRecorderRequest deleteConfigurationRecorderRequest) throws NoSuchConfigurationRecorderException,
            SdkBaseException, SdkClientException, ConfigException {

        HttpResponseHandler<DeleteConfigurationRecorderResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteConfigurationRecorderResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DeleteConfigurationRecorderRequest, DeleteConfigurationRecorderResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(deleteConfigurationRecorderRequest)
                        .withMarshaller(new DeleteConfigurationRecorderRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes the delivery channel.
     * </p>
     * <p>
     * Before you can delete the delivery channel, you must stop the configuration recorder by using the
     * <a>StopConfigurationRecorder</a> action.
     * </p>
     *
     * @param deleteDeliveryChannelRequest
     *        The input for the <a>DeleteDeliveryChannel</a> action. The action accepts the following data in JSON
     *        format.
     * @return Result of the DeleteDeliveryChannel operation returned by the service.
     * @throws NoSuchDeliveryChannelException
     *         You have specified a delivery channel that does not exist.
     * @throws LastDeliveryChannelDeleteFailedException
     *         You cannot delete the delivery channel you specified because the configuration recorder is running.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteDeliveryChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteDeliveryChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteDeliveryChannelResponse deleteDeliveryChannel(DeleteDeliveryChannelRequest deleteDeliveryChannelRequest)
            throws NoSuchDeliveryChannelException, LastDeliveryChannelDeleteFailedException, SdkBaseException,
            SdkClientException, ConfigException {

        HttpResponseHandler<DeleteDeliveryChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteDeliveryChannelResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteDeliveryChannelRequest, DeleteDeliveryChannelResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteDeliveryChannelRequest)
                .withMarshaller(new DeleteDeliveryChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes the evaluation results for the specified Config rule. You can specify one Config rule per request. After
     * you delete the evaluation results, you can call the <a>StartConfigRulesEvaluation</a> API to start evaluating
     * your AWS resources against the rule.
     * </p>
     *
     * @param deleteEvaluationResultsRequest
     * @return Result of the DeleteEvaluationResults operation returned by the service.
     * @throws NoSuchConfigRuleException
     *         One or more AWS Config rules in the request are invalid. Verify that the rule names are correct and try
     *         again.
     * @throws ResourceInUseException
     *         The rule is currently being deleted or the rule is deleting your evaluation results. Try your request
     *         again later.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteEvaluationResults
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteEvaluationResults" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteEvaluationResultsResponse deleteEvaluationResults(DeleteEvaluationResultsRequest deleteEvaluationResultsRequest)
            throws NoSuchConfigRuleException, ResourceInUseException, SdkBaseException, SdkClientException, ConfigException {

        HttpResponseHandler<DeleteEvaluationResultsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteEvaluationResultsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteEvaluationResultsRequest, DeleteEvaluationResultsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteEvaluationResultsRequest)
                .withMarshaller(new DeleteEvaluationResultsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Schedules delivery of a configuration snapshot to the Amazon S3 bucket in the specified delivery channel. After
     * the delivery has started, AWS Config sends following notifications using an Amazon SNS topic that you have
     * specified.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Notification of starting the delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * Notification of delivery completed, if the delivery was successfully completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Notification of delivery failure, if the delivery failed to complete.
     * </p>
     * </li>
     * </ul>
     *
     * @param deliverConfigSnapshotRequest
     *        The input for the <a>DeliverConfigSnapshot</a> action.
     * @return Result of the DeliverConfigSnapshot operation returned by the service.
     * @throws NoSuchDeliveryChannelException
     *         You have specified a delivery channel that does not exist.
     * @throws NoAvailableConfigurationRecorderException
     *         There are no configuration recorders available to provide the role needed to describe your resources.
     *         Create a configuration recorder.
     * @throws NoRunningConfigurationRecorderException
     *         There is no configuration recorder running.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeliverConfigSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeliverConfigSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeliverConfigSnapshotResponse deliverConfigSnapshot(DeliverConfigSnapshotRequest deliverConfigSnapshotRequest)
            throws NoSuchDeliveryChannelException, NoAvailableConfigurationRecorderException,
            NoRunningConfigurationRecorderException, SdkBaseException, SdkClientException, ConfigException {

        HttpResponseHandler<DeliverConfigSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeliverConfigSnapshotResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeliverConfigSnapshotRequest, DeliverConfigSnapshotResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deliverConfigSnapshotRequest)
                .withMarshaller(new DeliverConfigSnapshotRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Indicates whether the specified AWS Config rules are compliant. If a rule is noncompliant, this action returns
     * the number of AWS resources that do not comply with the rule.
     * </p>
     * <p>
     * A rule is compliant if all of the evaluated resources comply with it, and it is noncompliant if any of these
     * resources do not comply.
     * </p>
     * <p>
     * If AWS Config has no current evaluation results for the rule, it returns <code>INSUFFICIENT_DATA</code>. This
     * result might indicate one of the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AWS Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's AWS Lambda function is failing to send evaluation results to AWS Config. Verify that the role that you
     * assigned to your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule
     * is a custom rule, verify that the AWS Lambda execution role includes the <code>config:PutEvaluations</code>
     * permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's AWS Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can
     * occur if the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeComplianceByConfigRuleRequest
     * @return Result of the DescribeComplianceByConfigRule operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws NoSuchConfigRuleException
     *         One or more AWS Config rules in the request are invalid. Verify that the rule names are correct and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>NextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeComplianceByConfigRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeComplianceByConfigRuleResponse describeComplianceByConfigRule(
            DescribeComplianceByConfigRuleRequest describeComplianceByConfigRuleRequest) throws InvalidParameterValueException,
            NoSuchConfigRuleException, InvalidNextTokenException, SdkBaseException, SdkClientException, ConfigException {

        HttpResponseHandler<DescribeComplianceByConfigRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeComplianceByConfigRuleResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeComplianceByConfigRuleRequest, DescribeComplianceByConfigRuleResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeComplianceByConfigRuleRequest)
                        .withMarshaller(new DescribeComplianceByConfigRuleRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Indicates whether the specified AWS resources are compliant. If a resource is noncompliant, this action returns
     * the number of AWS Config rules that the resource does not comply with.
     * </p>
     * <p>
     * A resource is compliant if it complies with all the AWS Config rules that evaluate it. It is noncompliant if it
     * does not comply with one or more of these rules.
     * </p>
     * <p>
     * If AWS Config has no current evaluation results for the resource, it returns <code>INSUFFICIENT_DATA</code>. This
     * result might indicate one of the following conditions about the rules that evaluate the resource:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AWS Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's AWS Lambda function is failing to send evaluation results to AWS Config. Verify that the role that you
     * assigned to your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule
     * is a custom rule, verify that the AWS Lambda execution role includes the <code>config:PutEvaluations</code>
     * permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's AWS Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can
     * occur if the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeComplianceByResourceRequest
     * @return Result of the DescribeComplianceByResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>NextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeComplianceByResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeComplianceByResourceResponse describeComplianceByResource(
            DescribeComplianceByResourceRequest describeComplianceByResourceRequest) throws InvalidParameterValueException,
            InvalidNextTokenException, SdkBaseException, SdkClientException, ConfigException {

        HttpResponseHandler<DescribeComplianceByResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeComplianceByResourceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeComplianceByResourceRequest, DescribeComplianceByResourceResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeComplianceByResourceRequest)
                        .withMarshaller(new DescribeComplianceByResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns status information for each of your AWS managed Config rules. The status includes information such as the
     * last time AWS Config invoked the rule, the last time AWS Config failed to invoke the rule, and the related error
     * for the last failure.
     * </p>
     *
     * @param describeConfigRuleEvaluationStatusRequest
     * @return Result of the DescribeConfigRuleEvaluationStatus operation returned by the service.
     * @throws NoSuchConfigRuleException
     *         One or more AWS Config rules in the request are invalid. Verify that the rule names are correct and try
     *         again.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>NextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigRuleEvaluationStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeConfigRuleEvaluationStatusResponse describeConfigRuleEvaluationStatus(
            DescribeConfigRuleEvaluationStatusRequest describeConfigRuleEvaluationStatusRequest)
            throws NoSuchConfigRuleException, InvalidParameterValueException, InvalidNextTokenException, SdkBaseException,
            SdkClientException, ConfigException {

        HttpResponseHandler<DescribeConfigRuleEvaluationStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeConfigRuleEvaluationStatusResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeConfigRuleEvaluationStatusRequest, DescribeConfigRuleEvaluationStatusResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeConfigRuleEvaluationStatusRequest)
                        .withMarshaller(new DescribeConfigRuleEvaluationStatusRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns details about your AWS Config rules.
     * </p>
     *
     * @param describeConfigRulesRequest
     * @return Result of the DescribeConfigRules operation returned by the service.
     * @throws NoSuchConfigRuleException
     *         One or more AWS Config rules in the request are invalid. Verify that the rule names are correct and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>NextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeConfigRulesResponse describeConfigRules(DescribeConfigRulesRequest describeConfigRulesRequest)
            throws NoSuchConfigRuleException, InvalidNextTokenException, SdkBaseException, SdkClientException, ConfigException {

        HttpResponseHandler<DescribeConfigRulesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeConfigRulesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeConfigRulesRequest, DescribeConfigRulesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(describeConfigRulesRequest).withMarshaller(new DescribeConfigRulesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the current status of the specified configuration recorder. If a configuration recorder is not specified,
     * this action returns the status of all configuration recorder associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one configuration recorder per region in your account.
     * </p>
     * </note>
     *
     * @param describeConfigurationRecorderStatusRequest
     *        The input for the <a>DescribeConfigurationRecorderStatus</a> action.
     * @return Result of the DescribeConfigurationRecorderStatus operation returned by the service.
     * @throws NoSuchConfigurationRecorderException
     *         You have specified a configuration recorder that does not exist.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigurationRecorderStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorderStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeConfigurationRecorderStatusResponse describeConfigurationRecorderStatus(
            DescribeConfigurationRecorderStatusRequest describeConfigurationRecorderStatusRequest)
            throws NoSuchConfigurationRecorderException, SdkBaseException, SdkClientException, ConfigException {

        HttpResponseHandler<DescribeConfigurationRecorderStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeConfigurationRecorderStatusResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeConfigurationRecorderStatusRequest, DescribeConfigurationRecorderStatusResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeConfigurationRecorderStatusRequest)
                        .withMarshaller(new DescribeConfigurationRecorderStatusRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the details for the specified configuration recorders. If the configuration recorder is not specified,
     * this action returns the details for all configuration recorders associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one configuration recorder per region in your account.
     * </p>
     * </note>
     *
     * @param describeConfigurationRecordersRequest
     *        The input for the <a>DescribeConfigurationRecorders</a> action.
     * @return Result of the DescribeConfigurationRecorders operation returned by the service.
     * @throws NoSuchConfigurationRecorderException
     *         You have specified a configuration recorder that does not exist.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigurationRecorders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorders"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeConfigurationRecordersResponse describeConfigurationRecorders(
            DescribeConfigurationRecordersRequest describeConfigurationRecordersRequest)
            throws NoSuchConfigurationRecorderException, SdkBaseException, SdkClientException, ConfigException {

        HttpResponseHandler<DescribeConfigurationRecordersResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeConfigurationRecordersResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeConfigurationRecordersRequest, DescribeConfigurationRecordersResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeConfigurationRecordersRequest)
                        .withMarshaller(new DescribeConfigurationRecordersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the current status of the specified delivery channel. If a delivery channel is not specified, this action
     * returns the current status of all delivery channels associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one delivery channel per region in your account.
     * </p>
     * </note>
     *
     * @param describeDeliveryChannelStatusRequest
     *        The input for the <a>DeliveryChannelStatus</a> action.
     * @return Result of the DescribeDeliveryChannelStatus operation returned by the service.
     * @throws NoSuchDeliveryChannelException
     *         You have specified a delivery channel that does not exist.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeDeliveryChannelStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannelStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDeliveryChannelStatusResponse describeDeliveryChannelStatus(
            DescribeDeliveryChannelStatusRequest describeDeliveryChannelStatusRequest) throws NoSuchDeliveryChannelException,
            SdkBaseException, SdkClientException, ConfigException {

        HttpResponseHandler<DescribeDeliveryChannelStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeDeliveryChannelStatusResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeDeliveryChannelStatusRequest, DescribeDeliveryChannelStatusResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeDeliveryChannelStatusRequest)
                        .withMarshaller(new DescribeDeliveryChannelStatusRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns details about the specified delivery channel. If a delivery channel is not specified, this action returns
     * the details of all delivery channels associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one delivery channel per region in your account.
     * </p>
     * </note>
     *
     * @param describeDeliveryChannelsRequest
     *        The input for the <a>DescribeDeliveryChannels</a> action.
     * @return Result of the DescribeDeliveryChannels operation returned by the service.
     * @throws NoSuchDeliveryChannelException
     *         You have specified a delivery channel that does not exist.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeDeliveryChannels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannels"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDeliveryChannelsResponse describeDeliveryChannels(
            DescribeDeliveryChannelsRequest describeDeliveryChannelsRequest) throws NoSuchDeliveryChannelException,
            SdkBaseException, SdkClientException, ConfigException {

        HttpResponseHandler<DescribeDeliveryChannelsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeDeliveryChannelsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeDeliveryChannelsRequest, DescribeDeliveryChannelsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeDeliveryChannelsRequest)
                        .withMarshaller(new DescribeDeliveryChannelsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the evaluation results for the specified AWS Config rule. The results indicate which AWS resources were
     * evaluated by the rule, when each resource was last evaluated, and whether each resource complies with the rule.
     * </p>
     *
     * @param getComplianceDetailsByConfigRuleRequest
     * @return Result of the GetComplianceDetailsByConfigRule operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>NextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigRuleException
     *         One or more AWS Config rules in the request are invalid. Verify that the rule names are correct and try
     *         again.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetComplianceDetailsByConfigRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetComplianceDetailsByConfigRuleResponse getComplianceDetailsByConfigRule(
            GetComplianceDetailsByConfigRuleRequest getComplianceDetailsByConfigRuleRequest)
            throws InvalidParameterValueException, InvalidNextTokenException, NoSuchConfigRuleException, SdkBaseException,
            SdkClientException, ConfigException {

        HttpResponseHandler<GetComplianceDetailsByConfigRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetComplianceDetailsByConfigRuleResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<GetComplianceDetailsByConfigRuleRequest, GetComplianceDetailsByConfigRuleResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getComplianceDetailsByConfigRuleRequest)
                        .withMarshaller(new GetComplianceDetailsByConfigRuleRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the evaluation results for the specified AWS resource. The results indicate which AWS Config rules were
     * used to evaluate the resource, when each rule was last used, and whether the resource complies with each rule.
     * </p>
     *
     * @param getComplianceDetailsByResourceRequest
     * @return Result of the GetComplianceDetailsByResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetComplianceDetailsByResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetComplianceDetailsByResourceResponse getComplianceDetailsByResource(
            GetComplianceDetailsByResourceRequest getComplianceDetailsByResourceRequest) throws InvalidParameterValueException,
            SdkBaseException, SdkClientException, ConfigException {

        HttpResponseHandler<GetComplianceDetailsByResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetComplianceDetailsByResourceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<GetComplianceDetailsByResourceRequest, GetComplianceDetailsByResourceResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getComplianceDetailsByResourceRequest)
                        .withMarshaller(new GetComplianceDetailsByResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the number of AWS Config rules that are compliant and noncompliant, up to a maximum of 25 for each.
     * </p>
     *
     * @param getComplianceSummaryByConfigRuleRequest
     * @return Result of the GetComplianceSummaryByConfigRule operation returned by the service.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetComplianceSummaryByConfigRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetComplianceSummaryByConfigRuleResponse getComplianceSummaryByConfigRule(
            GetComplianceSummaryByConfigRuleRequest getComplianceSummaryByConfigRuleRequest) throws SdkBaseException,
            SdkClientException, ConfigException {

        HttpResponseHandler<GetComplianceSummaryByConfigRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetComplianceSummaryByConfigRuleResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<GetComplianceSummaryByConfigRuleRequest, GetComplianceSummaryByConfigRuleResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getComplianceSummaryByConfigRuleRequest)
                        .withMarshaller(new GetComplianceSummaryByConfigRuleRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the number of resources that are compliant and the number that are noncompliant. You can specify one or
     * more resource types to get these numbers for each resource type. The maximum number returned is 100.
     * </p>
     *
     * @param getComplianceSummaryByResourceTypeRequest
     * @return Result of the GetComplianceSummaryByResourceType operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetComplianceSummaryByResourceType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByResourceType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetComplianceSummaryByResourceTypeResponse getComplianceSummaryByResourceType(
            GetComplianceSummaryByResourceTypeRequest getComplianceSummaryByResourceTypeRequest)
            throws InvalidParameterValueException, SdkBaseException, SdkClientException, ConfigException {

        HttpResponseHandler<GetComplianceSummaryByResourceTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetComplianceSummaryByResourceTypeResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<GetComplianceSummaryByResourceTypeRequest, GetComplianceSummaryByResourceTypeResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getComplianceSummaryByResourceTypeRequest)
                        .withMarshaller(new GetComplianceSummaryByResourceTypeRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns a list of configuration items for the specified resource. The list contains details about each state of
     * the resource during the specified time interval.
     * </p>
     * <p>
     * The response is paginated, and by default, AWS Config returns a limit of 10 configuration items per page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string, and to get the next page of results, run the request again and enter this string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * Each call to the API is limited to span a duration of seven days. It is likely that the number of records
     * returned is smaller than the specified <code>limit</code>. In such cases, you can make another call, using the
     * <code>nextToken</code>.
     * </p>
     * </note>
     *
     * @param getResourceConfigHistoryRequest
     *        The input for the <a>GetResourceConfigHistory</a> action.
     * @return Result of the GetResourceConfigHistory operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.
     * @throws InvalidTimeRangeException
     *         The specified time range is not valid. The earlier time is not chronologically before the later time.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>NextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoAvailableConfigurationRecorderException
     *         There are no configuration recorders available to provide the role needed to describe your resources.
     *         Create a configuration recorder.
     * @throws ResourceNotDiscoveredException
     *         You have specified a resource that is either unknown or has not been discovered.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetResourceConfigHistory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetResourceConfigHistory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetResourceConfigHistoryResponse getResourceConfigHistory(
            GetResourceConfigHistoryRequest getResourceConfigHistoryRequest) throws ValidationException,
            InvalidTimeRangeException, InvalidLimitException, InvalidNextTokenException,
            NoAvailableConfigurationRecorderException, ResourceNotDiscoveredException, SdkBaseException, SdkClientException,
            ConfigException {

        HttpResponseHandler<GetResourceConfigHistoryResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetResourceConfigHistoryResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<GetResourceConfigHistoryRequest, GetResourceConfigHistoryResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getResourceConfigHistoryRequest)
                        .withMarshaller(new GetResourceConfigHistoryRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Accepts a resource type and returns a list of resource identifiers for the resources of that type. A resource
     * identifier includes the resource type, ID, and (if available) the custom resource name. The results consist of
     * resources that AWS Config has discovered, including those that AWS Config is not currently recording. You can
     * narrow the results to include only resources that have specific resource IDs or a resource name.
     * </p>
     * <note>
     * <p>
     * You can specify either resource IDs or a resource name but not both in the same request.
     * </p>
     * </note>
     * <p>
     * The response is paginated, and by default AWS Config lists 100 resource identifiers on each page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string, and to get the next page of results, run the request again and enter this string for the
     * <code>nextToken</code> parameter.
     * </p>
     *
     * @param listDiscoveredResourcesRequest
     * @return Result of the ListDiscoveredResources operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is invalid. Specify the <code>NextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoAvailableConfigurationRecorderException
     *         There are no configuration recorders available to provide the role needed to describe your resources.
     *         Create a configuration recorder.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListDiscoveredResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListDiscoveredResources" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListDiscoveredResourcesResponse listDiscoveredResources(ListDiscoveredResourcesRequest listDiscoveredResourcesRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException,
            NoAvailableConfigurationRecorderException, SdkBaseException, SdkClientException, ConfigException {

        HttpResponseHandler<ListDiscoveredResourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ListDiscoveredResourcesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListDiscoveredResourcesRequest, ListDiscoveredResourcesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listDiscoveredResourcesRequest)
                .withMarshaller(new ListDiscoveredResourcesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Adds or updates an AWS Config rule for evaluating whether your AWS resources comply with your desired
     * configurations.
     * </p>
     * <p>
     * You can use this action for custom Config rules and AWS managed Config rules. A custom Config rule is a rule that
     * you develop and maintain. An AWS managed Config rule is a customizable, predefined rule that AWS Config provides.
     * </p>
     * <p>
     * If you are adding a new custom Config rule, you must first create the AWS Lambda function that the rule invokes
     * to evaluate your resources. When you use the <code>PutConfigRule</code> action to add the rule to AWS Config, you
     * must specify the Amazon Resource Name (ARN) that AWS Lambda assigns to the function. Specify the ARN for the
     * <code>SourceIdentifier</code> key. This key is part of the <code>Source</code> object, which is part of the
     * <code>ConfigRule</code> object.
     * </p>
     * <p>
     * If you are adding an AWS managed Config rule, specify the rule's identifier for the <code>SourceIdentifier</code>
     * key. To reference AWS managed Config rule identifiers, see <a
     * href="http://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">About AWS
     * Managed Config Rules</a>.
     * </p>
     * <p>
     * For any new rule that you add, specify the <code>ConfigRuleName</code> in the <code>ConfigRule</code> object. Do
     * not specify the <code>ConfigRuleArn</code> or the <code>ConfigRuleId</code>. These values are generated by AWS
     * Config for new rules.
     * </p>
     * <p>
     * If you are updating a rule that you added previously, you can specify the rule by <code>ConfigRuleName</code>,
     * <code>ConfigRuleId</code>, or <code>ConfigRuleArn</code> in the <code>ConfigRule</code> data type that you use in
     * this request.
     * </p>
     * <p>
     * The maximum number of rules that AWS Config supports is 50.
     * </p>
     * <p>
     * For more information about requesting a rule limit increase, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config">AWS Config Limits</a>
     * in the <i>AWS General Reference Guide</i>.
     * </p>
     * <p>
     * For more information about developing and using AWS Config rules, see <a
     * href="http://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html">Evaluating AWS Resource
     * Configurations with AWS Config</a> in the <i>AWS Config Developer Guide</i>.
     * </p>
     *
     * @param putConfigRuleRequest
     * @return Result of the PutConfigRule operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws MaxNumberOfConfigRulesExceededException
     *         Failed to add the AWS Config rule because the account already contains the maximum number of 50 rules.
     *         Consider deleting any deactivated rules before adding new rules.
     * @throws ResourceInUseException
     *         The rule is currently being deleted or the rule is deleting your evaluation results. Try your request
     *         again later.
     * @throws InsufficientPermissionsException
     *         Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The rule cannot be created because the IAM role assigned to AWS Config lacks permissions to perform the
     *         config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The AWS Lambda function cannot be invoked. Check the function ARN, and check the function's permissions.
     *         </p>
     *         </li>
     * @throws NoAvailableConfigurationRecorderException
     *         There are no configuration recorders available to provide the role needed to describe your resources.
     *         Create a configuration recorder.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutConfigRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigRule" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutConfigRuleResponse putConfigRule(PutConfigRuleRequest putConfigRuleRequest) throws InvalidParameterValueException,
            MaxNumberOfConfigRulesExceededException, ResourceInUseException, InsufficientPermissionsException,
            NoAvailableConfigurationRecorderException, SdkBaseException, SdkClientException, ConfigException {

        HttpResponseHandler<PutConfigRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new PutConfigRuleResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<PutConfigRuleRequest, PutConfigRuleResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(putConfigRuleRequest).withMarshaller(new PutConfigRuleRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new configuration recorder to record the selected resource configurations.
     * </p>
     * <p>
     * You can use this action to change the role <code>roleARN</code> and/or the <code>recordingGroup</code> of an
     * existing recorder. To change the role, call the action on the existing configuration recorder and specify a role.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one configuration recorder per region in your account.
     * </p>
     * <p>
     * If <code>ConfigurationRecorder</code> does not have the <b>recordingGroup</b> parameter specified, the default is
     * to record all supported resource types.
     * </p>
     * </note>
     *
     * @param putConfigurationRecorderRequest
     *        The input for the <a>PutConfigurationRecorder</a> action.
     * @return Result of the PutConfigurationRecorder operation returned by the service.
     * @throws MaxNumberOfConfigurationRecordersExceededException
     *         You have reached the limit on the number of recorders you can create.
     * @throws InvalidConfigurationRecorderNameException
     *         You have provided a configuration recorder name that is not valid.
     * @throws InvalidRoleException
     *         You have provided a null or empty role ARN.
     * @throws InvalidRecordingGroupException
     *         AWS Config throws an exception if the recording group does not contain a valid list of resource types.
     *         Invalid values could also be incorrectly formatted.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutConfigurationRecorder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutConfigurationRecorderResponse putConfigurationRecorder(
            PutConfigurationRecorderRequest putConfigurationRecorderRequest)
            throws MaxNumberOfConfigurationRecordersExceededException, InvalidConfigurationRecorderNameException,
            InvalidRoleException, InvalidRecordingGroupException, SdkBaseException, SdkClientException, ConfigException {

        HttpResponseHandler<PutConfigurationRecorderResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new PutConfigurationRecorderResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<PutConfigurationRecorderRequest, PutConfigurationRecorderResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(putConfigurationRecorderRequest)
                        .withMarshaller(new PutConfigurationRecorderRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a delivery channel object to deliver configuration information to an Amazon S3 bucket and Amazon SNS
     * topic.
     * </p>
     * <p>
     * Before you can create a delivery channel, you must create a configuration recorder.
     * </p>
     * <p>
     * You can use this action to change the Amazon S3 bucket or an Amazon SNS topic of the existing delivery channel.
     * To change the Amazon S3 bucket or an Amazon SNS topic, call this action and specify the changed values for the S3
     * bucket and the SNS topic. If you specify a different value for either the S3 bucket or the SNS topic, this action
     * will keep the existing value for the parameter that is not changed.
     * </p>
     * <note>
     * <p>
     * You can have only one delivery channel per region in your account.
     * </p>
     * </note>
     *
     * @param putDeliveryChannelRequest
     *        The input for the <a>PutDeliveryChannel</a> action.
     * @return Result of the PutDeliveryChannel operation returned by the service.
     * @throws MaxNumberOfDeliveryChannelsExceededException
     *         You have reached the limit on the number of delivery channels you can create.
     * @throws NoAvailableConfigurationRecorderException
     *         There are no configuration recorders available to provide the role needed to describe your resources.
     *         Create a configuration recorder.
     * @throws InvalidDeliveryChannelNameException
     *         The specified delivery channel name is not valid.
     * @throws NoSuchBucketException
     *         The specified Amazon S3 bucket does not exist.
     * @throws InvalidS3KeyPrefixException
     *         The specified Amazon S3 key prefix is not valid.
     * @throws InvalidSNSTopicARNException
     *         The specified Amazon SNS topic does not exist.
     * @throws InsufficientDeliveryPolicyException
     *         Your Amazon S3 bucket policy does not permit AWS Config to write to it.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutDeliveryChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutDeliveryChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutDeliveryChannelResponse putDeliveryChannel(PutDeliveryChannelRequest putDeliveryChannelRequest)
            throws MaxNumberOfDeliveryChannelsExceededException, NoAvailableConfigurationRecorderException,
            InvalidDeliveryChannelNameException, NoSuchBucketException, InvalidS3KeyPrefixException, InvalidSNSTopicARNException,
            InsufficientDeliveryPolicyException, SdkBaseException, SdkClientException, ConfigException {

        HttpResponseHandler<PutDeliveryChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new PutDeliveryChannelResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<PutDeliveryChannelRequest, PutDeliveryChannelResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(putDeliveryChannelRequest).withMarshaller(new PutDeliveryChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Used by an AWS Lambda function to deliver evaluation results to AWS Config. This action is required in every AWS
     * Lambda function that is invoked by an AWS Config rule.
     * </p>
     *
     * @param putEvaluationsRequest
     * @return Result of the PutEvaluations operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws InvalidResultTokenException
     *         The specified <code>ResultToken</code> is invalid.
     * @throws NoSuchConfigRuleException
     *         One or more AWS Config rules in the request are invalid. Verify that the rule names are correct and try
     *         again.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutEvaluations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutEvaluations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutEvaluationsResponse putEvaluations(PutEvaluationsRequest putEvaluationsRequest)
            throws InvalidParameterValueException, InvalidResultTokenException, NoSuchConfigRuleException, SdkBaseException,
            SdkClientException, ConfigException {

        HttpResponseHandler<PutEvaluationsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new PutEvaluationsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<PutEvaluationsRequest, PutEvaluationsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(putEvaluationsRequest).withMarshaller(new PutEvaluationsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Runs an on-demand evaluation for the specified Config rules against the last known configuration state of the
     * resources. Use <code>StartConfigRulesEvaluation</code> when you want to test a rule that you updated is working
     * as expected. <code>StartConfigRulesEvaluation</code> does not re-record the latest configuration state for your
     * resources; it re-runs an evaluation against the last known state of your resources.
     * </p>
     * <p>
     * You can specify up to 25 Config rules per request.
     * </p>
     * <p>
     * An existing <code>StartConfigRulesEvaluation</code> call must complete for the specified rules before you can
     * call the API again. If you chose to have AWS Config stream to an Amazon SNS topic, you will receive a
     * <code>ConfigRuleEvaluationStarted</code> notification when the evaluation starts.
     * </p>
     * <note>
     * <p>
     * You don't need to call the <code>StartConfigRulesEvaluation</code> API to run an evaluation for a new rule. When
     * you create a new rule, AWS Config automatically evaluates your resources against the rule.
     * </p>
     * </note>
     * <p>
     * The <code>StartConfigRulesEvaluation</code> API is useful if you want to run on-demand evaluations, such as the
     * following example:
     * </p>
     * <ol>
     * <li>
     * <p>
     * You have a custom rule that evaluates your IAM resources every 24 hours.
     * </p>
     * </li>
     * <li>
     * <p>
     * You update your Lambda function to add additional conditions to your rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * Instead of waiting for the next periodic evaluation, you call the <code>StartConfigRulesEvaluation</code> API.
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Config invokes your Lambda function and evaluates your IAM resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * Your custom rule will still run periodic evaluations every 24 hours.
     * </p>
     * </li>
     * </ol>
     *
     * @param startConfigRulesEvaluationRequest
     * @return Result of the StartConfigRulesEvaluation operation returned by the service.
     * @throws NoSuchConfigRuleException
     *         One or more AWS Config rules in the request are invalid. Verify that the rule names are correct and try
     *         again.
     * @throws LimitExceededException
     *         This exception is thrown if an evaluation is in progress or if you call the
     *         <a>StartConfigRulesEvaluation</a> API more than once per minute.
     * @throws ResourceInUseException
     *         The rule is currently being deleted or the rule is deleting your evaluation results. Try your request
     *         again later.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are invalid. Verify that your parameters are valid and try again.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.StartConfigRulesEvaluation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartConfigRulesEvaluation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartConfigRulesEvaluationResponse startConfigRulesEvaluation(
            StartConfigRulesEvaluationRequest startConfigRulesEvaluationRequest) throws NoSuchConfigRuleException,
            LimitExceededException, ResourceInUseException, InvalidParameterValueException, SdkBaseException, SdkClientException,
            ConfigException {

        HttpResponseHandler<StartConfigRulesEvaluationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new StartConfigRulesEvaluationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<StartConfigRulesEvaluationRequest, StartConfigRulesEvaluationResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(startConfigRulesEvaluationRequest)
                        .withMarshaller(new StartConfigRulesEvaluationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Starts recording configurations of the AWS resources you have selected to record in your AWS account.
     * </p>
     * <p>
     * You must have created at least one delivery channel to successfully start the configuration recorder.
     * </p>
     *
     * @param startConfigurationRecorderRequest
     *        The input for the <a>StartConfigurationRecorder</a> action.
     * @return Result of the StartConfigurationRecorder operation returned by the service.
     * @throws NoSuchConfigurationRecorderException
     *         You have specified a configuration recorder that does not exist.
     * @throws NoAvailableDeliveryChannelException
     *         There is no delivery channel available to record configurations.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.StartConfigurationRecorder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartConfigurationRecorderResponse startConfigurationRecorder(
            StartConfigurationRecorderRequest startConfigurationRecorderRequest) throws NoSuchConfigurationRecorderException,
            NoAvailableDeliveryChannelException, SdkBaseException, SdkClientException, ConfigException {

        HttpResponseHandler<StartConfigurationRecorderResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new StartConfigurationRecorderResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<StartConfigurationRecorderRequest, StartConfigurationRecorderResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(startConfigurationRecorderRequest)
                        .withMarshaller(new StartConfigurationRecorderRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Stops recording configurations of the AWS resources you have selected to record in your AWS account.
     * </p>
     *
     * @param stopConfigurationRecorderRequest
     *        The input for the <a>StopConfigurationRecorder</a> action.
     * @return Result of the StopConfigurationRecorder operation returned by the service.
     * @throws NoSuchConfigurationRecorderException
     *         You have specified a configuration recorder that does not exist.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.StopConfigurationRecorder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StopConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StopConfigurationRecorderResponse stopConfigurationRecorder(
            StopConfigurationRecorderRequest stopConfigurationRecorderRequest) throws NoSuchConfigurationRecorderException,
            SdkBaseException, SdkClientException, ConfigException {

        HttpResponseHandler<StopConfigurationRecorderResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new StopConfigurationRecorderResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<StopConfigurationRecorderRequest, StopConfigurationRecorderResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(stopConfigurationRecorderRequest)
                        .withMarshaller(new StopConfigurationRecorderRequestMarshaller(protocolFactory)));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata()
                .withProtocolVersion("1.1")
                .withSupportsCbor(false)
                .withSupportsIon(false)
                .withBaseServiceExceptionClass(software.amazon.awssdk.services.config.model.ConfigException.class)
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("NoRunningConfigurationRecorderException").withModeledClass(
                                NoRunningConfigurationRecorderException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ResourceNotDiscoveredException").withModeledClass(
                                ResourceNotDiscoveredException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidParameterValueException").withModeledClass(
                                InvalidParameterValueException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ResourceInUseException").withModeledClass(
                                ResourceInUseException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("NoAvailableDeliveryChannelException").withModeledClass(
                                NoAvailableDeliveryChannelException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidResultTokenException").withModeledClass(
                                InvalidResultTokenException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("MaxNumberOfConfigurationRecordersExceededException")
                                .withModeledClass(MaxNumberOfConfigurationRecordersExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InsufficientDeliveryPolicyException").withModeledClass(
                                InsufficientDeliveryPolicyException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("NoSuchBucketException").withModeledClass(
                                NoSuchBucketException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("NoAvailableConfigurationRecorderException").withModeledClass(
                                NoAvailableConfigurationRecorderException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("NoSuchDeliveryChannelException").withModeledClass(
                                NoSuchDeliveryChannelException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(
                                InvalidNextTokenException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidRecordingGroupException").withModeledClass(
                                InvalidRecordingGroupException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidConfigurationRecorderNameException").withModeledClass(
                                InvalidConfigurationRecorderNameException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(
                                LimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("LastDeliveryChannelDeleteFailedException").withModeledClass(
                                LastDeliveryChannelDeleteFailedException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidSNSTopicARNException").withModeledClass(
                                InvalidSNSTopicARNException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidTimeRangeException").withModeledClass(
                                InvalidTimeRangeException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("NoSuchConfigRuleException").withModeledClass(
                                NoSuchConfigRuleException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidLimitException").withModeledClass(
                                InvalidLimitException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidRoleException").withModeledClass(
                                InvalidRoleException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("MaxNumberOfDeliveryChannelsExceededException")
                                .withModeledClass(MaxNumberOfDeliveryChannelsExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("NoSuchConfigurationRecorderException").withModeledClass(
                                NoSuchConfigurationRecorderException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ValidationException").withModeledClass(
                                ValidationException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidDeliveryChannelNameException").withModeledClass(
                                InvalidDeliveryChannelNameException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("MaxNumberOfConfigRulesExceededException").withModeledClass(
                                MaxNumberOfConfigRulesExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InsufficientPermissionsException").withModeledClass(
                                InsufficientPermissionsException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidS3KeyPrefixException").withModeledClass(
                                InvalidS3KeyPrefixException.class)));
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
