/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.ConfigRuleEvaluationStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Status information for your AWS managed Config rules. The status includes information such as the last time the rule
 * ran, the last time it failed, and the related error for the last failure.
 * </p>
 * <p>
 * This action does not return status information about custom Config rules.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ConfigRuleEvaluationStatus implements StructuredPojo,
        ToCopyableBuilder<ConfigRuleEvaluationStatus.Builder, ConfigRuleEvaluationStatus> {
    private final String configRuleName;

    private final String configRuleArn;

    private final String configRuleId;

    private final Instant lastSuccessfulInvocationTime;

    private final Instant lastFailedInvocationTime;

    private final Instant lastSuccessfulEvaluationTime;

    private final Instant lastFailedEvaluationTime;

    private final Instant firstActivatedTime;

    private final String lastErrorCode;

    private final String lastErrorMessage;

    private final Boolean firstEvaluationStarted;

    private ConfigRuleEvaluationStatus(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.configRuleArn = builder.configRuleArn;
        this.configRuleId = builder.configRuleId;
        this.lastSuccessfulInvocationTime = builder.lastSuccessfulInvocationTime;
        this.lastFailedInvocationTime = builder.lastFailedInvocationTime;
        this.lastSuccessfulEvaluationTime = builder.lastSuccessfulEvaluationTime;
        this.lastFailedEvaluationTime = builder.lastFailedEvaluationTime;
        this.firstActivatedTime = builder.firstActivatedTime;
        this.lastErrorCode = builder.lastErrorCode;
        this.lastErrorMessage = builder.lastErrorMessage;
        this.firstEvaluationStarted = builder.firstEvaluationStarted;
    }

    /**
     * <p>
     * The name of the AWS Config rule.
     * </p>
     * 
     * @return The name of the AWS Config rule.
     */
    public String configRuleName() {
        return configRuleName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Config rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Config rule.
     */
    public String configRuleArn() {
        return configRuleArn;
    }

    /**
     * <p>
     * The ID of the AWS Config rule.
     * </p>
     * 
     * @return The ID of the AWS Config rule.
     */
    public String configRuleId() {
        return configRuleId;
    }

    /**
     * <p>
     * The time that AWS Config last successfully invoked the AWS Config rule to evaluate your AWS resources.
     * </p>
     * 
     * @return The time that AWS Config last successfully invoked the AWS Config rule to evaluate your AWS resources.
     */
    public Instant lastSuccessfulInvocationTime() {
        return lastSuccessfulInvocationTime;
    }

    /**
     * <p>
     * The time that AWS Config last failed to invoke the AWS Config rule to evaluate your AWS resources.
     * </p>
     * 
     * @return The time that AWS Config last failed to invoke the AWS Config rule to evaluate your AWS resources.
     */
    public Instant lastFailedInvocationTime() {
        return lastFailedInvocationTime;
    }

    /**
     * <p>
     * The time that AWS Config last successfully evaluated your AWS resources against the rule.
     * </p>
     * 
     * @return The time that AWS Config last successfully evaluated your AWS resources against the rule.
     */
    public Instant lastSuccessfulEvaluationTime() {
        return lastSuccessfulEvaluationTime;
    }

    /**
     * <p>
     * The time that AWS Config last failed to evaluate your AWS resources against the rule.
     * </p>
     * 
     * @return The time that AWS Config last failed to evaluate your AWS resources against the rule.
     */
    public Instant lastFailedEvaluationTime() {
        return lastFailedEvaluationTime;
    }

    /**
     * <p>
     * The time that you first activated the AWS Config rule.
     * </p>
     * 
     * @return The time that you first activated the AWS Config rule.
     */
    public Instant firstActivatedTime() {
        return firstActivatedTime;
    }

    /**
     * <p>
     * The error code that AWS Config returned when the rule last failed.
     * </p>
     * 
     * @return The error code that AWS Config returned when the rule last failed.
     */
    public String lastErrorCode() {
        return lastErrorCode;
    }

    /**
     * <p>
     * The error message that AWS Config returned when the rule last failed.
     * </p>
     * 
     * @return The error message that AWS Config returned when the rule last failed.
     */
    public String lastErrorMessage() {
        return lastErrorMessage;
    }

    /**
     * <p>
     * Indicates whether AWS Config has evaluated your resources against the rule at least once.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>true</code> - AWS Config has evaluated your AWS resources against the rule at least once.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>false</code> - AWS Config has not once finished evaluating your AWS resources against the rule.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates whether AWS Config has evaluated your resources against the rule at least once.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>true</code> - AWS Config has evaluated your AWS resources against the rule at least once.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>false</code> - AWS Config has not once finished evaluating your AWS resources against the rule.
     *         </p>
     *         </li>
     */
    public Boolean firstEvaluationStarted() {
        return firstEvaluationStarted;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((configRuleName() == null) ? 0 : configRuleName().hashCode());
        hashCode = 31 * hashCode + ((configRuleArn() == null) ? 0 : configRuleArn().hashCode());
        hashCode = 31 * hashCode + ((configRuleId() == null) ? 0 : configRuleId().hashCode());
        hashCode = 31 * hashCode + ((lastSuccessfulInvocationTime() == null) ? 0 : lastSuccessfulInvocationTime().hashCode());
        hashCode = 31 * hashCode + ((lastFailedInvocationTime() == null) ? 0 : lastFailedInvocationTime().hashCode());
        hashCode = 31 * hashCode + ((lastSuccessfulEvaluationTime() == null) ? 0 : lastSuccessfulEvaluationTime().hashCode());
        hashCode = 31 * hashCode + ((lastFailedEvaluationTime() == null) ? 0 : lastFailedEvaluationTime().hashCode());
        hashCode = 31 * hashCode + ((firstActivatedTime() == null) ? 0 : firstActivatedTime().hashCode());
        hashCode = 31 * hashCode + ((lastErrorCode() == null) ? 0 : lastErrorCode().hashCode());
        hashCode = 31 * hashCode + ((lastErrorMessage() == null) ? 0 : lastErrorMessage().hashCode());
        hashCode = 31 * hashCode + ((firstEvaluationStarted() == null) ? 0 : firstEvaluationStarted().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigRuleEvaluationStatus)) {
            return false;
        }
        ConfigRuleEvaluationStatus other = (ConfigRuleEvaluationStatus) obj;
        if (other.configRuleName() == null ^ this.configRuleName() == null) {
            return false;
        }
        if (other.configRuleName() != null && !other.configRuleName().equals(this.configRuleName())) {
            return false;
        }
        if (other.configRuleArn() == null ^ this.configRuleArn() == null) {
            return false;
        }
        if (other.configRuleArn() != null && !other.configRuleArn().equals(this.configRuleArn())) {
            return false;
        }
        if (other.configRuleId() == null ^ this.configRuleId() == null) {
            return false;
        }
        if (other.configRuleId() != null && !other.configRuleId().equals(this.configRuleId())) {
            return false;
        }
        if (other.lastSuccessfulInvocationTime() == null ^ this.lastSuccessfulInvocationTime() == null) {
            return false;
        }
        if (other.lastSuccessfulInvocationTime() != null
                && !other.lastSuccessfulInvocationTime().equals(this.lastSuccessfulInvocationTime())) {
            return false;
        }
        if (other.lastFailedInvocationTime() == null ^ this.lastFailedInvocationTime() == null) {
            return false;
        }
        if (other.lastFailedInvocationTime() != null && !other.lastFailedInvocationTime().equals(this.lastFailedInvocationTime())) {
            return false;
        }
        if (other.lastSuccessfulEvaluationTime() == null ^ this.lastSuccessfulEvaluationTime() == null) {
            return false;
        }
        if (other.lastSuccessfulEvaluationTime() != null
                && !other.lastSuccessfulEvaluationTime().equals(this.lastSuccessfulEvaluationTime())) {
            return false;
        }
        if (other.lastFailedEvaluationTime() == null ^ this.lastFailedEvaluationTime() == null) {
            return false;
        }
        if (other.lastFailedEvaluationTime() != null && !other.lastFailedEvaluationTime().equals(this.lastFailedEvaluationTime())) {
            return false;
        }
        if (other.firstActivatedTime() == null ^ this.firstActivatedTime() == null) {
            return false;
        }
        if (other.firstActivatedTime() != null && !other.firstActivatedTime().equals(this.firstActivatedTime())) {
            return false;
        }
        if (other.lastErrorCode() == null ^ this.lastErrorCode() == null) {
            return false;
        }
        if (other.lastErrorCode() != null && !other.lastErrorCode().equals(this.lastErrorCode())) {
            return false;
        }
        if (other.lastErrorMessage() == null ^ this.lastErrorMessage() == null) {
            return false;
        }
        if (other.lastErrorMessage() != null && !other.lastErrorMessage().equals(this.lastErrorMessage())) {
            return false;
        }
        if (other.firstEvaluationStarted() == null ^ this.firstEvaluationStarted() == null) {
            return false;
        }
        if (other.firstEvaluationStarted() != null && !other.firstEvaluationStarted().equals(this.firstEvaluationStarted())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (configRuleName() != null) {
            sb.append("ConfigRuleName: ").append(configRuleName()).append(",");
        }
        if (configRuleArn() != null) {
            sb.append("ConfigRuleArn: ").append(configRuleArn()).append(",");
        }
        if (configRuleId() != null) {
            sb.append("ConfigRuleId: ").append(configRuleId()).append(",");
        }
        if (lastSuccessfulInvocationTime() != null) {
            sb.append("LastSuccessfulInvocationTime: ").append(lastSuccessfulInvocationTime()).append(",");
        }
        if (lastFailedInvocationTime() != null) {
            sb.append("LastFailedInvocationTime: ").append(lastFailedInvocationTime()).append(",");
        }
        if (lastSuccessfulEvaluationTime() != null) {
            sb.append("LastSuccessfulEvaluationTime: ").append(lastSuccessfulEvaluationTime()).append(",");
        }
        if (lastFailedEvaluationTime() != null) {
            sb.append("LastFailedEvaluationTime: ").append(lastFailedEvaluationTime()).append(",");
        }
        if (firstActivatedTime() != null) {
            sb.append("FirstActivatedTime: ").append(firstActivatedTime()).append(",");
        }
        if (lastErrorCode() != null) {
            sb.append("LastErrorCode: ").append(lastErrorCode()).append(",");
        }
        if (lastErrorMessage() != null) {
            sb.append("LastErrorMessage: ").append(lastErrorMessage()).append(",");
        }
        if (firstEvaluationStarted() != null) {
            sb.append("FirstEvaluationStarted: ").append(firstEvaluationStarted()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigRuleEvaluationStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ConfigRuleEvaluationStatus> {
        /**
         * <p>
         * The name of the AWS Config rule.
         * </p>
         * 
         * @param configRuleName
         *        The name of the AWS Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleName(String configRuleName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Config rule.
         * </p>
         * 
         * @param configRuleArn
         *        The Amazon Resource Name (ARN) of the AWS Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleArn(String configRuleArn);

        /**
         * <p>
         * The ID of the AWS Config rule.
         * </p>
         * 
         * @param configRuleId
         *        The ID of the AWS Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleId(String configRuleId);

        /**
         * <p>
         * The time that AWS Config last successfully invoked the AWS Config rule to evaluate your AWS resources.
         * </p>
         * 
         * @param lastSuccessfulInvocationTime
         *        The time that AWS Config last successfully invoked the AWS Config rule to evaluate your AWS resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulInvocationTime(Instant lastSuccessfulInvocationTime);

        /**
         * <p>
         * The time that AWS Config last failed to invoke the AWS Config rule to evaluate your AWS resources.
         * </p>
         * 
         * @param lastFailedInvocationTime
         *        The time that AWS Config last failed to invoke the AWS Config rule to evaluate your AWS resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastFailedInvocationTime(Instant lastFailedInvocationTime);

        /**
         * <p>
         * The time that AWS Config last successfully evaluated your AWS resources against the rule.
         * </p>
         * 
         * @param lastSuccessfulEvaluationTime
         *        The time that AWS Config last successfully evaluated your AWS resources against the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulEvaluationTime(Instant lastSuccessfulEvaluationTime);

        /**
         * <p>
         * The time that AWS Config last failed to evaluate your AWS resources against the rule.
         * </p>
         * 
         * @param lastFailedEvaluationTime
         *        The time that AWS Config last failed to evaluate your AWS resources against the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastFailedEvaluationTime(Instant lastFailedEvaluationTime);

        /**
         * <p>
         * The time that you first activated the AWS Config rule.
         * </p>
         * 
         * @param firstActivatedTime
         *        The time that you first activated the AWS Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstActivatedTime(Instant firstActivatedTime);

        /**
         * <p>
         * The error code that AWS Config returned when the rule last failed.
         * </p>
         * 
         * @param lastErrorCode
         *        The error code that AWS Config returned when the rule last failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastErrorCode(String lastErrorCode);

        /**
         * <p>
         * The error message that AWS Config returned when the rule last failed.
         * </p>
         * 
         * @param lastErrorMessage
         *        The error message that AWS Config returned when the rule last failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastErrorMessage(String lastErrorMessage);

        /**
         * <p>
         * Indicates whether AWS Config has evaluated your resources against the rule at least once.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>true</code> - AWS Config has evaluated your AWS resources against the rule at least once.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>false</code> - AWS Config has not once finished evaluating your AWS resources against the rule.
         * </p>
         * </li>
         * </ul>
         * 
         * @param firstEvaluationStarted
         *        Indicates whether AWS Config has evaluated your resources against the rule at least once.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>true</code> - AWS Config has evaluated your AWS resources against the rule at least once.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>false</code> - AWS Config has not once finished evaluating your AWS resources against the rule.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstEvaluationStarted(Boolean firstEvaluationStarted);
    }

    private static final class BuilderImpl implements Builder {
        private String configRuleName;

        private String configRuleArn;

        private String configRuleId;

        private Instant lastSuccessfulInvocationTime;

        private Instant lastFailedInvocationTime;

        private Instant lastSuccessfulEvaluationTime;

        private Instant lastFailedEvaluationTime;

        private Instant firstActivatedTime;

        private String lastErrorCode;

        private String lastErrorMessage;

        private Boolean firstEvaluationStarted;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigRuleEvaluationStatus model) {
            setConfigRuleName(model.configRuleName);
            setConfigRuleArn(model.configRuleArn);
            setConfigRuleId(model.configRuleId);
            setLastSuccessfulInvocationTime(model.lastSuccessfulInvocationTime);
            setLastFailedInvocationTime(model.lastFailedInvocationTime);
            setLastSuccessfulEvaluationTime(model.lastSuccessfulEvaluationTime);
            setLastFailedEvaluationTime(model.lastFailedEvaluationTime);
            setFirstActivatedTime(model.firstActivatedTime);
            setLastErrorCode(model.lastErrorCode);
            setLastErrorMessage(model.lastErrorMessage);
            setFirstEvaluationStarted(model.firstEvaluationStarted);
        }

        public final String getConfigRuleName() {
            return configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final String getConfigRuleArn() {
            return configRuleArn;
        }

        @Override
        public final Builder configRuleArn(String configRuleArn) {
            this.configRuleArn = configRuleArn;
            return this;
        }

        public final void setConfigRuleArn(String configRuleArn) {
            this.configRuleArn = configRuleArn;
        }

        public final String getConfigRuleId() {
            return configRuleId;
        }

        @Override
        public final Builder configRuleId(String configRuleId) {
            this.configRuleId = configRuleId;
            return this;
        }

        public final void setConfigRuleId(String configRuleId) {
            this.configRuleId = configRuleId;
        }

        public final Instant getLastSuccessfulInvocationTime() {
            return lastSuccessfulInvocationTime;
        }

        @Override
        public final Builder lastSuccessfulInvocationTime(Instant lastSuccessfulInvocationTime) {
            this.lastSuccessfulInvocationTime = lastSuccessfulInvocationTime;
            return this;
        }

        public final void setLastSuccessfulInvocationTime(Instant lastSuccessfulInvocationTime) {
            this.lastSuccessfulInvocationTime = lastSuccessfulInvocationTime;
        }

        public final Instant getLastFailedInvocationTime() {
            return lastFailedInvocationTime;
        }

        @Override
        public final Builder lastFailedInvocationTime(Instant lastFailedInvocationTime) {
            this.lastFailedInvocationTime = lastFailedInvocationTime;
            return this;
        }

        public final void setLastFailedInvocationTime(Instant lastFailedInvocationTime) {
            this.lastFailedInvocationTime = lastFailedInvocationTime;
        }

        public final Instant getLastSuccessfulEvaluationTime() {
            return lastSuccessfulEvaluationTime;
        }

        @Override
        public final Builder lastSuccessfulEvaluationTime(Instant lastSuccessfulEvaluationTime) {
            this.lastSuccessfulEvaluationTime = lastSuccessfulEvaluationTime;
            return this;
        }

        public final void setLastSuccessfulEvaluationTime(Instant lastSuccessfulEvaluationTime) {
            this.lastSuccessfulEvaluationTime = lastSuccessfulEvaluationTime;
        }

        public final Instant getLastFailedEvaluationTime() {
            return lastFailedEvaluationTime;
        }

        @Override
        public final Builder lastFailedEvaluationTime(Instant lastFailedEvaluationTime) {
            this.lastFailedEvaluationTime = lastFailedEvaluationTime;
            return this;
        }

        public final void setLastFailedEvaluationTime(Instant lastFailedEvaluationTime) {
            this.lastFailedEvaluationTime = lastFailedEvaluationTime;
        }

        public final Instant getFirstActivatedTime() {
            return firstActivatedTime;
        }

        @Override
        public final Builder firstActivatedTime(Instant firstActivatedTime) {
            this.firstActivatedTime = firstActivatedTime;
            return this;
        }

        public final void setFirstActivatedTime(Instant firstActivatedTime) {
            this.firstActivatedTime = firstActivatedTime;
        }

        public final String getLastErrorCode() {
            return lastErrorCode;
        }

        @Override
        public final Builder lastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
            return this;
        }

        public final void setLastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
        }

        public final String getLastErrorMessage() {
            return lastErrorMessage;
        }

        @Override
        public final Builder lastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
            return this;
        }

        public final void setLastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
        }

        public final Boolean getFirstEvaluationStarted() {
            return firstEvaluationStarted;
        }

        @Override
        public final Builder firstEvaluationStarted(Boolean firstEvaluationStarted) {
            this.firstEvaluationStarted = firstEvaluationStarted;
            return this;
        }

        public final void setFirstEvaluationStarted(Boolean firstEvaluationStarted) {
            this.firstEvaluationStarted = firstEvaluationStarted;
        }

        @Override
        public ConfigRuleEvaluationStatus build() {
            return new ConfigRuleEvaluationStatus(this);
        }
    }
}
