/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeComplianceByResourceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeComplianceByResourceRequest.Builder, DescribeComplianceByResourceRequest> {
    private final String resourceType;

    private final String resourceId;

    private final List<String> complianceTypes;

    private final Integer limit;

    private final String nextToken;

    private DescribeComplianceByResourceRequest(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.complianceTypes = builder.complianceTypes;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The types of AWS resources for which you want compliance information; for example,
     * <code>AWS::EC2::Instance</code>. For this action, you can specify that the resource type is an AWS account by
     * specifying <code>AWS::::Account</code>.
     * </p>
     * 
     * @return The types of AWS resources for which you want compliance information; for example,
     *         <code>AWS::EC2::Instance</code>. For this action, you can specify that the resource type is an AWS
     *         account by specifying <code>AWS::::Account</code>.
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The ID of the AWS resource for which you want compliance information. You can specify only one resource ID. If
     * you specify a resource ID, you must also specify a type for <code>ResourceType</code>.
     * </p>
     * 
     * @return The ID of the AWS resource for which you want compliance information. You can specify only one resource
     *         ID. If you specify a resource ID, you must also specify a type for <code>ResourceType</code>.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * Filters the results by compliance.
     * </p>
     * <p>
     * The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Filters the results by compliance.</p>
     *         <p>
     *         The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and
     *         <code>INSUFFICIENT_DATA</code>.
     * @see ComplianceType
     */
    public List<String> complianceTypes() {
        return complianceTypes;
    }

    /**
     * <p>
     * The maximum number of evaluation results returned on each page. The default is 10. You cannot specify a limit
     * greater than 100. If you specify 0, AWS Config uses the default.
     * </p>
     * 
     * @return The maximum number of evaluation results returned on each page. The default is 10. You cannot specify a
     *         limit greater than 100. If you specify 0, AWS Config uses the default.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The <code>NextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>NextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((resourceType() == null) ? 0 : resourceType().hashCode());
        hashCode = 31 * hashCode + ((resourceId() == null) ? 0 : resourceId().hashCode());
        hashCode = 31 * hashCode + ((complianceTypes() == null) ? 0 : complianceTypes().hashCode());
        hashCode = 31 * hashCode + ((limit() == null) ? 0 : limit().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComplianceByResourceRequest)) {
            return false;
        }
        DescribeComplianceByResourceRequest other = (DescribeComplianceByResourceRequest) obj;
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.complianceTypes() == null ^ this.complianceTypes() == null) {
            return false;
        }
        if (other.complianceTypes() != null && !other.complianceTypes().equals(this.complianceTypes())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (resourceType() != null) {
            sb.append("ResourceType: ").append(resourceType()).append(",");
        }
        if (resourceId() != null) {
            sb.append("ResourceId: ").append(resourceId()).append(",");
        }
        if (complianceTypes() != null) {
            sb.append("ComplianceTypes: ").append(complianceTypes()).append(",");
        }
        if (limit() != null) {
            sb.append("Limit: ").append(limit()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeComplianceByResourceRequest> {
        /**
         * <p>
         * The types of AWS resources for which you want compliance information; for example,
         * <code>AWS::EC2::Instance</code>. For this action, you can specify that the resource type is an AWS account by
         * specifying <code>AWS::::Account</code>.
         * </p>
         * 
         * @param resourceType
         *        The types of AWS resources for which you want compliance information; for example,
         *        <code>AWS::EC2::Instance</code>. For this action, you can specify that the resource type is an AWS
         *        account by specifying <code>AWS::::Account</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The ID of the AWS resource for which you want compliance information. You can specify only one resource ID.
         * If you specify a resource ID, you must also specify a type for <code>ResourceType</code>.
         * </p>
         * 
         * @param resourceId
         *        The ID of the AWS resource for which you want compliance information. You can specify only one
         *        resource ID. If you specify a resource ID, you must also specify a type for <code>ResourceType</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * Filters the results by compliance.
         * </p>
         * <p>
         * The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code>
         * .
         * </p>
         * 
         * @param complianceTypes
         *        Filters the results by compliance.</p>
         *        <p>
         *        The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and
         *        <code>INSUFFICIENT_DATA</code>.
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder complianceTypes(Collection<String> complianceTypes);

        /**
         * <p>
         * Filters the results by compliance.
         * </p>
         * <p>
         * The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code>
         * .
         * </p>
         * 
         * @param complianceTypes
         *        Filters the results by compliance.</p>
         *        <p>
         *        The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and
         *        <code>INSUFFICIENT_DATA</code>.
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder complianceTypes(String... complianceTypes);

        /**
         * <p>
         * Filters the results by compliance.
         * </p>
         * <p>
         * The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code>
         * .
         * </p>
         * 
         * @param complianceTypes
         *        Filters the results by compliance.</p>
         *        <p>
         *        The allowed values are <code>COMPLIANT</code>, <code>NON_COMPLIANT</code>, and
         *        <code>INSUFFICIENT_DATA</code>.
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder complianceTypes(ComplianceType... complianceTypes);

        /**
         * <p>
         * The maximum number of evaluation results returned on each page. The default is 10. You cannot specify a limit
         * greater than 100. If you specify 0, AWS Config uses the default.
         * </p>
         * 
         * @param limit
         *        The maximum number of evaluation results returned on each page. The default is 10. You cannot specify
         *        a limit greater than 100. If you specify 0, AWS Config uses the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The <code>NextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>NextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private String resourceType;

        private String resourceId;

        private List<String> complianceTypes;

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComplianceByResourceRequest model) {
            setResourceType(model.resourceType);
            setResourceId(model.resourceId);
            setComplianceTypes(model.complianceTypes);
            setLimit(model.limit);
            setNextToken(model.nextToken);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Collection<String> getComplianceTypes() {
            return complianceTypes;
        }

        @Override
        public final Builder complianceTypes(Collection<String> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copy(complianceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceTypes(String... complianceTypes) {
            complianceTypes(Arrays.asList(complianceTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceTypes(ComplianceType... complianceTypes) {
            complianceTypes(Arrays.asList(complianceTypes).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setComplianceTypes(Collection<String> complianceTypes) {
            this.complianceTypes = ComplianceTypesCopier.copy(complianceTypes);
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeComplianceByResourceRequest build() {
            return new DescribeComplianceByResourceRequest(this);
        }
    }
}
