/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeConfigRulesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeConfigRulesRequest.Builder, DescribeConfigRulesRequest> {
    private final List<String> configRuleNames;

    private final String nextToken;

    private DescribeConfigRulesRequest(BuilderImpl builder) {
        this.configRuleNames = builder.configRuleNames;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The names of the AWS Config rules for which you want details. If you do not specify any names, AWS Config returns
     * details for all your rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of the AWS Config rules for which you want details. If you do not specify any names, AWS Config
     *         returns details for all your rules.
     */
    public List<String> configRuleNames() {
        return configRuleNames;
    }

    /**
     * <p>
     * The <code>NextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>NextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((configRuleNames() == null) ? 0 : configRuleNames().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigRulesRequest)) {
            return false;
        }
        DescribeConfigRulesRequest other = (DescribeConfigRulesRequest) obj;
        if (other.configRuleNames() == null ^ this.configRuleNames() == null) {
            return false;
        }
        if (other.configRuleNames() != null && !other.configRuleNames().equals(this.configRuleNames())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (configRuleNames() != null) {
            sb.append("ConfigRuleNames: ").append(configRuleNames()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeConfigRulesRequest> {
        /**
         * <p>
         * The names of the AWS Config rules for which you want details. If you do not specify any names, AWS Config
         * returns details for all your rules.
         * </p>
         * 
         * @param configRuleNames
         *        The names of the AWS Config rules for which you want details. If you do not specify any names, AWS
         *        Config returns details for all your rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleNames(Collection<String> configRuleNames);

        /**
         * <p>
         * The names of the AWS Config rules for which you want details. If you do not specify any names, AWS Config
         * returns details for all your rules.
         * </p>
         * 
         * @param configRuleNames
         *        The names of the AWS Config rules for which you want details. If you do not specify any names, AWS
         *        Config returns details for all your rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleNames(String... configRuleNames);

        /**
         * <p>
         * The <code>NextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>NextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> configRuleNames;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigRulesRequest model) {
            setConfigRuleNames(model.configRuleNames);
            setNextToken(model.nextToken);
        }

        public final Collection<String> getConfigRuleNames() {
            return configRuleNames;
        }

        @Override
        public final Builder configRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConfigRuleNamesCopier.copy(configRuleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRuleNames(String... configRuleNames) {
            configRuleNames(Arrays.asList(configRuleNames));
            return this;
        }

        public final void setConfigRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConfigRuleNamesCopier.copy(configRuleNames);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeConfigRulesRequest build() {
            return new DescribeConfigRulesRequest(this);
        }
    }
}
