/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the <a>DescribeConfigurationRecorderStatus</a> action in JSON format.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeConfigurationRecorderStatusResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeConfigurationRecorderStatusResponse.Builder, DescribeConfigurationRecorderStatusResponse> {
    private final List<ConfigurationRecorderStatus> configurationRecordersStatus;

    private DescribeConfigurationRecorderStatusResponse(BuilderImpl builder) {
        this.configurationRecordersStatus = builder.configurationRecordersStatus;
    }

    /**
     * <p>
     * A list that contains status of the specified recorders.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list that contains status of the specified recorders.
     */
    public List<ConfigurationRecorderStatus> configurationRecordersStatus() {
        return configurationRecordersStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((configurationRecordersStatus() == null) ? 0 : configurationRecordersStatus().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationRecorderStatusResponse)) {
            return false;
        }
        DescribeConfigurationRecorderStatusResponse other = (DescribeConfigurationRecorderStatusResponse) obj;
        if (other.configurationRecordersStatus() == null ^ this.configurationRecordersStatus() == null) {
            return false;
        }
        if (other.configurationRecordersStatus() != null
                && !other.configurationRecordersStatus().equals(this.configurationRecordersStatus())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (configurationRecordersStatus() != null) {
            sb.append("ConfigurationRecordersStatus: ").append(configurationRecordersStatus()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeConfigurationRecorderStatusResponse> {
        /**
         * <p>
         * A list that contains status of the specified recorders.
         * </p>
         * 
         * @param configurationRecordersStatus
         *        A list that contains status of the specified recorders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecordersStatus(Collection<ConfigurationRecorderStatus> configurationRecordersStatus);

        /**
         * <p>
         * A list that contains status of the specified recorders.
         * </p>
         * 
         * @param configurationRecordersStatus
         *        A list that contains status of the specified recorders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecordersStatus(ConfigurationRecorderStatus... configurationRecordersStatus);
    }

    private static final class BuilderImpl implements Builder {
        private List<ConfigurationRecorderStatus> configurationRecordersStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationRecorderStatusResponse model) {
            setConfigurationRecordersStatus(model.configurationRecordersStatus);
        }

        public final Collection<ConfigurationRecorderStatus> getConfigurationRecordersStatus() {
            return configurationRecordersStatus;
        }

        @Override
        public final Builder configurationRecordersStatus(Collection<ConfigurationRecorderStatus> configurationRecordersStatus) {
            this.configurationRecordersStatus = ConfigurationRecorderStatusListCopier.copy(configurationRecordersStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationRecordersStatus(ConfigurationRecorderStatus... configurationRecordersStatus) {
            configurationRecordersStatus(Arrays.asList(configurationRecordersStatus));
            return this;
        }

        public final void setConfigurationRecordersStatus(Collection<ConfigurationRecorderStatus> configurationRecordersStatus) {
            this.configurationRecordersStatus = ConfigurationRecorderStatusListCopier.copy(configurationRecordersStatus);
        }

        @Override
        public DescribeConfigurationRecorderStatusResponse build() {
            return new DescribeConfigurationRecorderStatusResponse(this);
        }
    }
}
