/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>DescribeDeliveryChannels</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeDeliveryChannelsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeDeliveryChannelsRequest.Builder, DescribeDeliveryChannelsRequest> {
    private final List<String> deliveryChannelNames;

    private DescribeDeliveryChannelsRequest(BuilderImpl builder) {
        this.deliveryChannelNames = builder.deliveryChannelNames;
    }

    /**
     * <p>
     * A list of delivery channel names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of delivery channel names.
     */
    public List<String> deliveryChannelNames() {
        return deliveryChannelNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deliveryChannelNames() == null) ? 0 : deliveryChannelNames().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeliveryChannelsRequest)) {
            return false;
        }
        DescribeDeliveryChannelsRequest other = (DescribeDeliveryChannelsRequest) obj;
        if (other.deliveryChannelNames() == null ^ this.deliveryChannelNames() == null) {
            return false;
        }
        if (other.deliveryChannelNames() != null && !other.deliveryChannelNames().equals(this.deliveryChannelNames())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deliveryChannelNames() != null) {
            sb.append("DeliveryChannelNames: ").append(deliveryChannelNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeDeliveryChannelsRequest> {
        /**
         * <p>
         * A list of delivery channel names.
         * </p>
         * 
         * @param deliveryChannelNames
         *        A list of delivery channel names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryChannelNames(Collection<String> deliveryChannelNames);

        /**
         * <p>
         * A list of delivery channel names.
         * </p>
         * 
         * @param deliveryChannelNames
         *        A list of delivery channel names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryChannelNames(String... deliveryChannelNames);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> deliveryChannelNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeliveryChannelsRequest model) {
            setDeliveryChannelNames(model.deliveryChannelNames);
        }

        public final Collection<String> getDeliveryChannelNames() {
            return deliveryChannelNames;
        }

        @Override
        public final Builder deliveryChannelNames(Collection<String> deliveryChannelNames) {
            this.deliveryChannelNames = DeliveryChannelNameListCopier.copy(deliveryChannelNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryChannelNames(String... deliveryChannelNames) {
            deliveryChannelNames(Arrays.asList(deliveryChannelNames));
            return this;
        }

        public final void setDeliveryChannelNames(Collection<String> deliveryChannelNames) {
            this.deliveryChannelNames = DeliveryChannelNameListCopier.copy(deliveryChannelNames);
        }

        @Override
        public DescribeDeliveryChannelsRequest build() {
            return new DescribeDeliveryChannelsRequest(this);
        }
    }
}
