/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.EvaluationResultMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of an AWS Config evaluation. Provides the AWS resource that was evaluated, the compliance of the
 * resource, related timestamps, and supplementary information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class EvaluationResult implements StructuredPojo, ToCopyableBuilder<EvaluationResult.Builder, EvaluationResult> {
    private final EvaluationResultIdentifier evaluationResultIdentifier;

    private final String complianceType;

    private final Instant resultRecordedTime;

    private final Instant configRuleInvokedTime;

    private final String annotation;

    private final String resultToken;

    private EvaluationResult(BuilderImpl builder) {
        this.evaluationResultIdentifier = builder.evaluationResultIdentifier;
        this.complianceType = builder.complianceType;
        this.resultRecordedTime = builder.resultRecordedTime;
        this.configRuleInvokedTime = builder.configRuleInvokedTime;
        this.annotation = builder.annotation;
        this.resultToken = builder.resultToken;
    }

    /**
     * <p>
     * Uniquely identifies the evaluation result.
     * </p>
     * 
     * @return Uniquely identifies the evaluation result.
     */
    public EvaluationResultIdentifier evaluationResultIdentifier() {
        return evaluationResultIdentifier;
    }

    /**
     * <p>
     * Indicates whether the AWS resource complies with the AWS Config rule that evaluated it.
     * </p>
     * <p>
     * For the <code>EvaluationResult</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
     * <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
     * <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.
     * </p>
     * 
     * @return Indicates whether the AWS resource complies with the AWS Config rule that evaluated it.</p>
     *         <p>
     *         For the <code>EvaluationResult</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
     *         <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
     *         <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.
     * @see ComplianceType
     */
    public String complianceType() {
        return complianceType;
    }

    /**
     * <p>
     * The time when AWS Config recorded the evaluation result.
     * </p>
     * 
     * @return The time when AWS Config recorded the evaluation result.
     */
    public Instant resultRecordedTime() {
        return resultRecordedTime;
    }

    /**
     * <p>
     * The time when the AWS Config rule evaluated the AWS resource.
     * </p>
     * 
     * @return The time when the AWS Config rule evaluated the AWS resource.
     */
    public Instant configRuleInvokedTime() {
        return configRuleInvokedTime;
    }

    /**
     * <p>
     * Supplementary information about how the evaluation determined the compliance.
     * </p>
     * 
     * @return Supplementary information about how the evaluation determined the compliance.
     */
    public String annotation() {
        return annotation;
    }

    /**
     * <p>
     * An encrypted token that associates an evaluation with an AWS Config rule. The token identifies the rule, the AWS
     * resource being evaluated, and the event that triggered the evaluation.
     * </p>
     * 
     * @return An encrypted token that associates an evaluation with an AWS Config rule. The token identifies the rule,
     *         the AWS resource being evaluated, and the event that triggered the evaluation.
     */
    public String resultToken() {
        return resultToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((evaluationResultIdentifier() == null) ? 0 : evaluationResultIdentifier().hashCode());
        hashCode = 31 * hashCode + ((complianceType() == null) ? 0 : complianceType().hashCode());
        hashCode = 31 * hashCode + ((resultRecordedTime() == null) ? 0 : resultRecordedTime().hashCode());
        hashCode = 31 * hashCode + ((configRuleInvokedTime() == null) ? 0 : configRuleInvokedTime().hashCode());
        hashCode = 31 * hashCode + ((annotation() == null) ? 0 : annotation().hashCode());
        hashCode = 31 * hashCode + ((resultToken() == null) ? 0 : resultToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationResult)) {
            return false;
        }
        EvaluationResult other = (EvaluationResult) obj;
        if (other.evaluationResultIdentifier() == null ^ this.evaluationResultIdentifier() == null) {
            return false;
        }
        if (other.evaluationResultIdentifier() != null
                && !other.evaluationResultIdentifier().equals(this.evaluationResultIdentifier())) {
            return false;
        }
        if (other.complianceType() == null ^ this.complianceType() == null) {
            return false;
        }
        if (other.complianceType() != null && !other.complianceType().equals(this.complianceType())) {
            return false;
        }
        if (other.resultRecordedTime() == null ^ this.resultRecordedTime() == null) {
            return false;
        }
        if (other.resultRecordedTime() != null && !other.resultRecordedTime().equals(this.resultRecordedTime())) {
            return false;
        }
        if (other.configRuleInvokedTime() == null ^ this.configRuleInvokedTime() == null) {
            return false;
        }
        if (other.configRuleInvokedTime() != null && !other.configRuleInvokedTime().equals(this.configRuleInvokedTime())) {
            return false;
        }
        if (other.annotation() == null ^ this.annotation() == null) {
            return false;
        }
        if (other.annotation() != null && !other.annotation().equals(this.annotation())) {
            return false;
        }
        if (other.resultToken() == null ^ this.resultToken() == null) {
            return false;
        }
        if (other.resultToken() != null && !other.resultToken().equals(this.resultToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (evaluationResultIdentifier() != null) {
            sb.append("EvaluationResultIdentifier: ").append(evaluationResultIdentifier()).append(",");
        }
        if (complianceType() != null) {
            sb.append("ComplianceType: ").append(complianceType()).append(",");
        }
        if (resultRecordedTime() != null) {
            sb.append("ResultRecordedTime: ").append(resultRecordedTime()).append(",");
        }
        if (configRuleInvokedTime() != null) {
            sb.append("ConfigRuleInvokedTime: ").append(configRuleInvokedTime()).append(",");
        }
        if (annotation() != null) {
            sb.append("Annotation: ").append(annotation()).append(",");
        }
        if (resultToken() != null) {
            sb.append("ResultToken: ").append(resultToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EvaluationResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, EvaluationResult> {
        /**
         * <p>
         * Uniquely identifies the evaluation result.
         * </p>
         * 
         * @param evaluationResultIdentifier
         *        Uniquely identifies the evaluation result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationResultIdentifier(EvaluationResultIdentifier evaluationResultIdentifier);

        /**
         * <p>
         * Indicates whether the AWS resource complies with the AWS Config rule that evaluated it.
         * </p>
         * <p>
         * For the <code>EvaluationResult</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
         * <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
         * <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.
         * </p>
         * 
         * @param complianceType
         *        Indicates whether the AWS resource complies with the AWS Config rule that evaluated it.</p>
         *        <p>
         *        For the <code>EvaluationResult</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
         *        <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
         *        <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * Indicates whether the AWS resource complies with the AWS Config rule that evaluated it.
         * </p>
         * <p>
         * For the <code>EvaluationResult</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
         * <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
         * <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.
         * </p>
         * 
         * @param complianceType
         *        Indicates whether the AWS resource complies with the AWS Config rule that evaluated it.</p>
         *        <p>
         *        For the <code>EvaluationResult</code> data type, AWS Config supports only the <code>COMPLIANT</code>,
         *        <code>NON_COMPLIANT</code>, and <code>NOT_APPLICABLE</code> values. AWS Config does not support the
         *        <code>INSUFFICIENT_DATA</code> value for the <code>EvaluationResult</code> data type.
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder complianceType(ComplianceType complianceType);

        /**
         * <p>
         * The time when AWS Config recorded the evaluation result.
         * </p>
         * 
         * @param resultRecordedTime
         *        The time when AWS Config recorded the evaluation result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultRecordedTime(Instant resultRecordedTime);

        /**
         * <p>
         * The time when the AWS Config rule evaluated the AWS resource.
         * </p>
         * 
         * @param configRuleInvokedTime
         *        The time when the AWS Config rule evaluated the AWS resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleInvokedTime(Instant configRuleInvokedTime);

        /**
         * <p>
         * Supplementary information about how the evaluation determined the compliance.
         * </p>
         * 
         * @param annotation
         *        Supplementary information about how the evaluation determined the compliance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotation(String annotation);

        /**
         * <p>
         * An encrypted token that associates an evaluation with an AWS Config rule. The token identifies the rule, the
         * AWS resource being evaluated, and the event that triggered the evaluation.
         * </p>
         * 
         * @param resultToken
         *        An encrypted token that associates an evaluation with an AWS Config rule. The token identifies the
         *        rule, the AWS resource being evaluated, and the event that triggered the evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultToken(String resultToken);
    }

    private static final class BuilderImpl implements Builder {
        private EvaluationResultIdentifier evaluationResultIdentifier;

        private String complianceType;

        private Instant resultRecordedTime;

        private Instant configRuleInvokedTime;

        private String annotation;

        private String resultToken;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationResult model) {
            setEvaluationResultIdentifier(model.evaluationResultIdentifier);
            setComplianceType(model.complianceType);
            setResultRecordedTime(model.resultRecordedTime);
            setConfigRuleInvokedTime(model.configRuleInvokedTime);
            setAnnotation(model.annotation);
            setResultToken(model.resultToken);
        }

        public final EvaluationResultIdentifier getEvaluationResultIdentifier() {
            return evaluationResultIdentifier;
        }

        @Override
        public final Builder evaluationResultIdentifier(EvaluationResultIdentifier evaluationResultIdentifier) {
            this.evaluationResultIdentifier = evaluationResultIdentifier;
            return this;
        }

        public final void setEvaluationResultIdentifier(EvaluationResultIdentifier evaluationResultIdentifier) {
            this.evaluationResultIdentifier = evaluationResultIdentifier;
        }

        public final String getComplianceType() {
            return complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ComplianceType complianceType) {
            this.complianceType(complianceType.toString());
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final Instant getResultRecordedTime() {
            return resultRecordedTime;
        }

        @Override
        public final Builder resultRecordedTime(Instant resultRecordedTime) {
            this.resultRecordedTime = resultRecordedTime;
            return this;
        }

        public final void setResultRecordedTime(Instant resultRecordedTime) {
            this.resultRecordedTime = resultRecordedTime;
        }

        public final Instant getConfigRuleInvokedTime() {
            return configRuleInvokedTime;
        }

        @Override
        public final Builder configRuleInvokedTime(Instant configRuleInvokedTime) {
            this.configRuleInvokedTime = configRuleInvokedTime;
            return this;
        }

        public final void setConfigRuleInvokedTime(Instant configRuleInvokedTime) {
            this.configRuleInvokedTime = configRuleInvokedTime;
        }

        public final String getAnnotation() {
            return annotation;
        }

        @Override
        public final Builder annotation(String annotation) {
            this.annotation = annotation;
            return this;
        }

        public final void setAnnotation(String annotation) {
            this.annotation = annotation;
        }

        public final String getResultToken() {
            return resultToken;
        }

        @Override
        public final Builder resultToken(String resultToken) {
            this.resultToken = resultToken;
            return this;
        }

        public final void setResultToken(String resultToken) {
            this.resultToken = resultToken;
        }

        @Override
        public EvaluationResult build() {
            return new EvaluationResult(this);
        }
    }
}
