/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetComplianceSummaryByResourceTypeRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetComplianceSummaryByResourceTypeRequest.Builder, GetComplianceSummaryByResourceTypeRequest> {
    private final List<String> resourceTypes;

    private GetComplianceSummaryByResourceTypeRequest(BuilderImpl builder) {
        this.resourceTypes = builder.resourceTypes;
    }

    /**
     * <p>
     * Specify one or more resource types to get the number of resources that are compliant and the number that are
     * noncompliant for each resource type.
     * </p>
     * <p>
     * For this request, you can specify an AWS resource type such as <code>AWS::EC2::Instance</code>, and you can
     * specify that the resource type is an AWS account by specifying <code>AWS::::Account</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specify one or more resource types to get the number of resources that are compliant and the number that
     *         are noncompliant for each resource type.</p>
     *         <p>
     *         For this request, you can specify an AWS resource type such as <code>AWS::EC2::Instance</code>, and you
     *         can specify that the resource type is an AWS account by specifying <code>AWS::::Account</code>.
     */
    public List<String> resourceTypes() {
        return resourceTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((resourceTypes() == null) ? 0 : resourceTypes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComplianceSummaryByResourceTypeRequest)) {
            return false;
        }
        GetComplianceSummaryByResourceTypeRequest other = (GetComplianceSummaryByResourceTypeRequest) obj;
        if (other.resourceTypes() == null ^ this.resourceTypes() == null) {
            return false;
        }
        if (other.resourceTypes() != null && !other.resourceTypes().equals(this.resourceTypes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (resourceTypes() != null) {
            sb.append("ResourceTypes: ").append(resourceTypes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetComplianceSummaryByResourceTypeRequest> {
        /**
         * <p>
         * Specify one or more resource types to get the number of resources that are compliant and the number that are
         * noncompliant for each resource type.
         * </p>
         * <p>
         * For this request, you can specify an AWS resource type such as <code>AWS::EC2::Instance</code>, and you can
         * specify that the resource type is an AWS account by specifying <code>AWS::::Account</code>.
         * </p>
         * 
         * @param resourceTypes
         *        Specify one or more resource types to get the number of resources that are compliant and the number
         *        that are noncompliant for each resource type.</p>
         *        <p>
         *        For this request, you can specify an AWS resource type such as <code>AWS::EC2::Instance</code>, and
         *        you can specify that the resource type is an AWS account by specifying <code>AWS::::Account</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<String> resourceTypes);

        /**
         * <p>
         * Specify one or more resource types to get the number of resources that are compliant and the number that are
         * noncompliant for each resource type.
         * </p>
         * <p>
         * For this request, you can specify an AWS resource type such as <code>AWS::EC2::Instance</code>, and you can
         * specify that the resource type is an AWS account by specifying <code>AWS::::Account</code>.
         * </p>
         * 
         * @param resourceTypes
         *        Specify one or more resource types to get the number of resources that are compliant and the number
         *        that are noncompliant for each resource type.</p>
         *        <p>
         *        For this request, you can specify an AWS resource type such as <code>AWS::EC2::Instance</code>, and
         *        you can specify that the resource type is an AWS account by specifying <code>AWS::::Account</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(String... resourceTypes);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> resourceTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComplianceSummaryByResourceTypeRequest model) {
            setResourceTypes(model.resourceTypes);
        }

        public final Collection<String> getResourceTypes() {
            return resourceTypes;
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        @Override
        public GetComplianceSummaryByResourceTypeRequest build() {
            return new GetComplianceSummaryByResourceTypeRequest(this);
        }
    }
}
