/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>GetResourceConfigHistory</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetResourceConfigHistoryRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetResourceConfigHistoryRequest.Builder, GetResourceConfigHistoryRequest> {
    private final String resourceType;

    private final String resourceId;

    private final Instant laterTime;

    private final Instant earlierTime;

    private final String chronologicalOrder;

    private final Integer limit;

    private final String nextToken;

    private GetResourceConfigHistoryRequest(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.laterTime = builder.laterTime;
        this.earlierTime = builder.earlierTime;
        this.chronologicalOrder = builder.chronologicalOrder;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * 
     * @return The resource type.
     * @see ResourceType
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The ID of the resource (for example., <code>sg-xxxxxx</code>).
     * </p>
     * 
     * @return The ID of the resource (for example., <code>sg-xxxxxx</code>).
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The time stamp that indicates a later time. If not specified, current time is taken.
     * </p>
     * 
     * @return The time stamp that indicates a later time. If not specified, current time is taken.
     */
    public Instant laterTime() {
        return laterTime;
    }

    /**
     * <p>
     * The time stamp that indicates an earlier time. If not specified, the action returns paginated results that
     * contain configuration items that start from when the first configuration item was recorded.
     * </p>
     * 
     * @return The time stamp that indicates an earlier time. If not specified, the action returns paginated results
     *         that contain configuration items that start from when the first configuration item was recorded.
     */
    public Instant earlierTime() {
        return earlierTime;
    }

    /**
     * <p>
     * The chronological order for configuration items listed. By default the results are listed in reverse
     * chronological order.
     * </p>
     * 
     * @return The chronological order for configuration items listed. By default the results are listed in reverse
     *         chronological order.
     * @see ChronologicalOrder
     */
    public String chronologicalOrder() {
        return chronologicalOrder;
    }

    /**
     * <p>
     * The maximum number of configuration items returned on each page. The default is 10. You cannot specify a limit
     * greater than 100. If you specify 0, AWS Config uses the default.
     * </p>
     * 
     * @return The maximum number of configuration items returned on each page. The default is 10. You cannot specify a
     *         limit greater than 100. If you specify 0, AWS Config uses the default.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((resourceType() == null) ? 0 : resourceType().hashCode());
        hashCode = 31 * hashCode + ((resourceId() == null) ? 0 : resourceId().hashCode());
        hashCode = 31 * hashCode + ((laterTime() == null) ? 0 : laterTime().hashCode());
        hashCode = 31 * hashCode + ((earlierTime() == null) ? 0 : earlierTime().hashCode());
        hashCode = 31 * hashCode + ((chronologicalOrder() == null) ? 0 : chronologicalOrder().hashCode());
        hashCode = 31 * hashCode + ((limit() == null) ? 0 : limit().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceConfigHistoryRequest)) {
            return false;
        }
        GetResourceConfigHistoryRequest other = (GetResourceConfigHistoryRequest) obj;
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.laterTime() == null ^ this.laterTime() == null) {
            return false;
        }
        if (other.laterTime() != null && !other.laterTime().equals(this.laterTime())) {
            return false;
        }
        if (other.earlierTime() == null ^ this.earlierTime() == null) {
            return false;
        }
        if (other.earlierTime() != null && !other.earlierTime().equals(this.earlierTime())) {
            return false;
        }
        if (other.chronologicalOrder() == null ^ this.chronologicalOrder() == null) {
            return false;
        }
        if (other.chronologicalOrder() != null && !other.chronologicalOrder().equals(this.chronologicalOrder())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (resourceType() != null) {
            sb.append("ResourceType: ").append(resourceType()).append(",");
        }
        if (resourceId() != null) {
            sb.append("ResourceId: ").append(resourceId()).append(",");
        }
        if (laterTime() != null) {
            sb.append("LaterTime: ").append(laterTime()).append(",");
        }
        if (earlierTime() != null) {
            sb.append("EarlierTime: ").append(earlierTime()).append(",");
        }
        if (chronologicalOrder() != null) {
            sb.append("ChronologicalOrder: ").append(chronologicalOrder()).append(",");
        }
        if (limit() != null) {
            sb.append("Limit: ").append(limit()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetResourceConfigHistoryRequest> {
        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceType
         *        The resource type.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceType
         *        The resource type.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The ID of the resource (for example., <code>sg-xxxxxx</code>).
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource (for example., <code>sg-xxxxxx</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The time stamp that indicates a later time. If not specified, current time is taken.
         * </p>
         * 
         * @param laterTime
         *        The time stamp that indicates a later time. If not specified, current time is taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder laterTime(Instant laterTime);

        /**
         * <p>
         * The time stamp that indicates an earlier time. If not specified, the action returns paginated results that
         * contain configuration items that start from when the first configuration item was recorded.
         * </p>
         * 
         * @param earlierTime
         *        The time stamp that indicates an earlier time. If not specified, the action returns paginated results
         *        that contain configuration items that start from when the first configuration item was recorded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder earlierTime(Instant earlierTime);

        /**
         * <p>
         * The chronological order for configuration items listed. By default the results are listed in reverse
         * chronological order.
         * </p>
         * 
         * @param chronologicalOrder
         *        The chronological order for configuration items listed. By default the results are listed in reverse
         *        chronological order.
         * @see ChronologicalOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChronologicalOrder
         */
        Builder chronologicalOrder(String chronologicalOrder);

        /**
         * <p>
         * The chronological order for configuration items listed. By default the results are listed in reverse
         * chronological order.
         * </p>
         * 
         * @param chronologicalOrder
         *        The chronological order for configuration items listed. By default the results are listed in reverse
         *        chronological order.
         * @see ChronologicalOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChronologicalOrder
         */
        Builder chronologicalOrder(ChronologicalOrder chronologicalOrder);

        /**
         * <p>
         * The maximum number of configuration items returned on each page. The default is 10. You cannot specify a
         * limit greater than 100. If you specify 0, AWS Config uses the default.
         * </p>
         * 
         * @param limit
         *        The maximum number of configuration items returned on each page. The default is 10. You cannot specify
         *        a limit greater than 100. If you specify 0, AWS Config uses the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private String resourceType;

        private String resourceId;

        private Instant laterTime;

        private Instant earlierTime;

        private String chronologicalOrder;

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceConfigHistoryRequest model) {
            setResourceType(model.resourceType);
            setResourceId(model.resourceId);
            setLaterTime(model.laterTime);
            setEarlierTime(model.earlierTime);
            setChronologicalOrder(model.chronologicalOrder);
            setLimit(model.limit);
            setNextToken(model.nextToken);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Instant getLaterTime() {
            return laterTime;
        }

        @Override
        public final Builder laterTime(Instant laterTime) {
            this.laterTime = laterTime;
            return this;
        }

        public final void setLaterTime(Instant laterTime) {
            this.laterTime = laterTime;
        }

        public final Instant getEarlierTime() {
            return earlierTime;
        }

        @Override
        public final Builder earlierTime(Instant earlierTime) {
            this.earlierTime = earlierTime;
            return this;
        }

        public final void setEarlierTime(Instant earlierTime) {
            this.earlierTime = earlierTime;
        }

        public final String getChronologicalOrder() {
            return chronologicalOrder;
        }

        @Override
        public final Builder chronologicalOrder(String chronologicalOrder) {
            this.chronologicalOrder = chronologicalOrder;
            return this;
        }

        @Override
        public final Builder chronologicalOrder(ChronologicalOrder chronologicalOrder) {
            this.chronologicalOrder(chronologicalOrder.toString());
            return this;
        }

        public final void setChronologicalOrder(String chronologicalOrder) {
            this.chronologicalOrder = chronologicalOrder;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetResourceConfigHistoryRequest build() {
            return new GetResourceConfigHistoryRequest(this);
        }
    }
}
