/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutConfigRuleRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutConfigRuleRequest.Builder, PutConfigRuleRequest> {
    private final ConfigRule configRule;

    private PutConfigRuleRequest(BuilderImpl builder) {
        this.configRule = builder.configRule;
    }

    /**
     * <p>
     * The rule that you want to add to your account.
     * </p>
     * 
     * @return The rule that you want to add to your account.
     */
    public ConfigRule configRule() {
        return configRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((configRule() == null) ? 0 : configRule().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConfigRuleRequest)) {
            return false;
        }
        PutConfigRuleRequest other = (PutConfigRuleRequest) obj;
        if (other.configRule() == null ^ this.configRule() == null) {
            return false;
        }
        if (other.configRule() != null && !other.configRule().equals(this.configRule())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (configRule() != null) {
            sb.append("ConfigRule: ").append(configRule()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutConfigRuleRequest> {
        /**
         * <p>
         * The rule that you want to add to your account.
         * </p>
         * 
         * @param configRule
         *        The rule that you want to add to your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRule(ConfigRule configRule);
    }

    private static final class BuilderImpl implements Builder {
        private ConfigRule configRule;

        private BuilderImpl() {
        }

        private BuilderImpl(PutConfigRuleRequest model) {
            setConfigRule(model.configRule);
        }

        public final ConfigRule getConfigRule() {
            return configRule;
        }

        @Override
        public final Builder configRule(ConfigRule configRule) {
            this.configRule = configRule;
            return this;
        }

        public final void setConfigRule(ConfigRule configRule) {
            this.configRule = configRule;
        }

        @Override
        public PutConfigRuleRequest build() {
            return new PutConfigRuleRequest(this);
        }
    }
}
