/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>PutDeliveryChannel</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PutDeliveryChannelRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutDeliveryChannelRequest.Builder, PutDeliveryChannelRequest> {
    private final DeliveryChannel deliveryChannel;

    private PutDeliveryChannelRequest(BuilderImpl builder) {
        this.deliveryChannel = builder.deliveryChannel;
    }

    /**
     * <p>
     * The configuration delivery channel object that delivers the configuration information to an Amazon S3 bucket, and
     * to an Amazon SNS topic.
     * </p>
     * 
     * @return The configuration delivery channel object that delivers the configuration information to an Amazon S3
     *         bucket, and to an Amazon SNS topic.
     */
    public DeliveryChannel deliveryChannel() {
        return deliveryChannel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deliveryChannel() == null) ? 0 : deliveryChannel().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDeliveryChannelRequest)) {
            return false;
        }
        PutDeliveryChannelRequest other = (PutDeliveryChannelRequest) obj;
        if (other.deliveryChannel() == null ^ this.deliveryChannel() == null) {
            return false;
        }
        if (other.deliveryChannel() != null && !other.deliveryChannel().equals(this.deliveryChannel())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deliveryChannel() != null) {
            sb.append("DeliveryChannel: ").append(deliveryChannel()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutDeliveryChannelRequest> {
        /**
         * <p>
         * The configuration delivery channel object that delivers the configuration information to an Amazon S3 bucket,
         * and to an Amazon SNS topic.
         * </p>
         * 
         * @param deliveryChannel
         *        The configuration delivery channel object that delivers the configuration information to an Amazon S3
         *        bucket, and to an Amazon SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryChannel(DeliveryChannel deliveryChannel);
    }

    private static final class BuilderImpl implements Builder {
        private DeliveryChannel deliveryChannel;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDeliveryChannelRequest model) {
            setDeliveryChannel(model.deliveryChannel);
        }

        public final DeliveryChannel getDeliveryChannel() {
            return deliveryChannel;
        }

        @Override
        public final Builder deliveryChannel(DeliveryChannel deliveryChannel) {
            this.deliveryChannel = deliveryChannel;
            return this;
        }

        public final void setDeliveryChannel(DeliveryChannel deliveryChannel) {
            this.deliveryChannel = deliveryChannel;
        }

        @Override
        public PutDeliveryChannelRequest build() {
            return new PutDeliveryChannelRequest(this);
        }
    }
}
