/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.ComplianceSummary;
import software.amazon.awssdk.services.config.transform.ComplianceSummaryByResourceTypeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ComplianceSummaryByResourceType
implements StructuredPojo,
ToCopyableBuilder<Builder, ComplianceSummaryByResourceType> {
    private final String resourceType;
    private final ComplianceSummary complianceSummary;

    private ComplianceSummaryByResourceType(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.complianceSummary = builder.complianceSummary;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public ComplianceSummary complianceSummary() {
        return this.complianceSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceType() == null ? 0 : this.resourceType().hashCode());
        hashCode = 31 * hashCode + (this.complianceSummary() == null ? 0 : this.complianceSummary().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceSummaryByResourceType)) {
            return false;
        }
        ComplianceSummaryByResourceType other = (ComplianceSummaryByResourceType)obj;
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.complianceSummary() == null ^ this.complianceSummary() == null) {
            return false;
        }
        return other.complianceSummary() == null || other.complianceSummary().equals(this.complianceSummary());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resourceType() != null) {
            sb.append("ResourceType: ").append(this.resourceType()).append(",");
        }
        if (this.complianceSummary() != null) {
            sb.append("ComplianceSummary: ").append(this.complianceSummary()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComplianceSummaryByResourceTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private ComplianceSummary complianceSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceSummaryByResourceType model) {
            this.setResourceType(model.resourceType);
            this.setComplianceSummary(model.complianceSummary);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final ComplianceSummary getComplianceSummary() {
            return this.complianceSummary;
        }

        @Override
        public final Builder complianceSummary(ComplianceSummary complianceSummary) {
            this.complianceSummary = complianceSummary;
            return this;
        }

        public final void setComplianceSummary(ComplianceSummary complianceSummary) {
            this.complianceSummary = complianceSummary;
        }

        public ComplianceSummaryByResourceType build() {
            return new ComplianceSummaryByResourceType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ComplianceSummaryByResourceType> {
        public Builder resourceType(String var1);

        public Builder complianceSummary(ComplianceSummary var1);
    }
}

