/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.model.Owner;
import software.amazon.awssdk.services.config.model.SourceDetail;
import software.amazon.awssdk.services.config.model.SourceDetailsCopier;
import software.amazon.awssdk.services.config.transform.SourceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Source
implements StructuredPojo,
ToCopyableBuilder<Builder, Source> {
    private final String owner;
    private final String sourceIdentifier;
    private final List<SourceDetail> sourceDetails;

    private Source(BuilderImpl builder) {
        this.owner = builder.owner;
        this.sourceIdentifier = builder.sourceIdentifier;
        this.sourceDetails = builder.sourceDetails;
    }

    public String owner() {
        return this.owner;
    }

    public String sourceIdentifier() {
        return this.sourceIdentifier;
    }

    public List<SourceDetail> sourceDetails() {
        return this.sourceDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.owner() == null ? 0 : this.owner().hashCode());
        hashCode = 31 * hashCode + (this.sourceIdentifier() == null ? 0 : this.sourceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.sourceDetails() == null ? 0 : this.sourceDetails().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source other = (Source)obj;
        if (other.owner() == null ^ this.owner() == null) {
            return false;
        }
        if (other.owner() != null && !other.owner().equals(this.owner())) {
            return false;
        }
        if (other.sourceIdentifier() == null ^ this.sourceIdentifier() == null) {
            return false;
        }
        if (other.sourceIdentifier() != null && !other.sourceIdentifier().equals(this.sourceIdentifier())) {
            return false;
        }
        if (other.sourceDetails() == null ^ this.sourceDetails() == null) {
            return false;
        }
        return other.sourceDetails() == null || other.sourceDetails().equals(this.sourceDetails());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.owner() != null) {
            sb.append("Owner: ").append(this.owner()).append(",");
        }
        if (this.sourceIdentifier() != null) {
            sb.append("SourceIdentifier: ").append(this.sourceIdentifier()).append(",");
        }
        if (this.sourceDetails() != null) {
            sb.append("SourceDetails: ").append(this.sourceDetails()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String owner;
        private String sourceIdentifier;
        private List<SourceDetail> sourceDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(Source model) {
            this.setOwner(model.owner);
            this.setSourceIdentifier(model.sourceIdentifier);
            this.setSourceDetails(model.sourceDetails);
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner(owner.toString());
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getSourceIdentifier() {
            return this.sourceIdentifier;
        }

        @Override
        public final Builder sourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
            return this;
        }

        public final void setSourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
        }

        public final Collection<SourceDetail> getSourceDetails() {
            return this.sourceDetails;
        }

        @Override
        public final Builder sourceDetails(Collection<SourceDetail> sourceDetails) {
            this.sourceDetails = SourceDetailsCopier.copy(sourceDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDetails(SourceDetail ... sourceDetails) {
            this.sourceDetails(Arrays.asList(sourceDetails));
            return this;
        }

        public final void setSourceDetails(Collection<SourceDetail> sourceDetails) {
            this.sourceDetails = SourceDetailsCopier.copy(sourceDetails);
        }

        public Source build() {
            return new Source(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Source> {
        public Builder owner(String var1);

        public Builder owner(Owner var1);

        public Builder sourceIdentifier(String var1);

        public Builder sourceDetails(Collection<SourceDetail> var1);

        public Builder sourceDetails(SourceDetail ... var1);
    }
}

