/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.config.model.ConfigurationItem;
import software.amazon.awssdk.services.config.transform.RelationshipUnmarshaller;

public class ConfigurationItemUnmarshaller
implements Unmarshaller<ConfigurationItem, JsonUnmarshallerContext> {
    private static final ConfigurationItemUnmarshaller INSTANCE = new ConfigurationItemUnmarshaller();

    public ConfigurationItem unmarshall(JsonUnmarshallerContext context) throws Exception {
        ConfigurationItem.Builder configurationItemBuilder = ConfigurationItem.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("version", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.version((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("accountId", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.accountId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("configurationItemCaptureTime", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.configurationItemCaptureTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("configurationItemStatus", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.configurationItemStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("configurationStateId", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.configurationStateId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("configurationItemMD5Hash", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.configurationItemMD5Hash((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("resourceType", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.resourceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("resourceId", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.resourceId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("resourceName", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.resourceName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("awsRegion", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.awsRegion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("availabilityZone", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.availabilityZone((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("resourceCreationTime", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.resourceCreationTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("tags", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.tags(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("relatedEvents", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.relatedEvents(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("relationships", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.relationships(new ListUnmarshaller((Unmarshaller)RelationshipUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("configuration", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.configuration((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("supplementaryConfiguration", targetDepth)) {
                    context.nextToken();
                    configurationItemBuilder.supplementaryConfiguration(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ConfigurationItem)configurationItemBuilder.build();
    }

    public static ConfigurationItemUnmarshaller getInstance() {
        return INSTANCE;
    }
}

