/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.ComplianceByConfigRuleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates whether an AWS Config rule is compliant. A rule is compliant if all of the resources that the rule
 * evaluated comply with it, and it is noncompliant if any of these resources do not comply.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ComplianceByConfigRule implements StructuredPojo,
        ToCopyableBuilder<ComplianceByConfigRule.Builder, ComplianceByConfigRule> {
    private final String configRuleName;

    private final Compliance compliance;

    private ComplianceByConfigRule(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.compliance = builder.compliance;
    }

    /**
     * <p>
     * The name of the AWS Config rule.
     * </p>
     * 
     * @return The name of the AWS Config rule.
     */
    public String configRuleName() {
        return configRuleName;
    }

    /**
     * <p>
     * Indicates whether the AWS Config rule is compliant.
     * </p>
     * 
     * @return Indicates whether the AWS Config rule is compliant.
     */
    public Compliance compliance() {
        return compliance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((configRuleName() == null) ? 0 : configRuleName().hashCode());
        hashCode = 31 * hashCode + ((compliance() == null) ? 0 : compliance().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceByConfigRule)) {
            return false;
        }
        ComplianceByConfigRule other = (ComplianceByConfigRule) obj;
        if (other.configRuleName() == null ^ this.configRuleName() == null) {
            return false;
        }
        if (other.configRuleName() != null && !other.configRuleName().equals(this.configRuleName())) {
            return false;
        }
        if (other.compliance() == null ^ this.compliance() == null) {
            return false;
        }
        if (other.compliance() != null && !other.compliance().equals(this.compliance())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (configRuleName() != null) {
            sb.append("ConfigRuleName: ").append(configRuleName()).append(",");
        }
        if (compliance() != null) {
            sb.append("Compliance: ").append(compliance()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleName":
            return Optional.of(clazz.cast(configRuleName()));
        case "Compliance":
            return Optional.of(clazz.cast(compliance()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComplianceByConfigRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ComplianceByConfigRule> {
        /**
         * <p>
         * The name of the AWS Config rule.
         * </p>
         * 
         * @param configRuleName
         *        The name of the AWS Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleName(String configRuleName);

        /**
         * <p>
         * Indicates whether the AWS Config rule is compliant.
         * </p>
         * 
         * @param compliance
         *        Indicates whether the AWS Config rule is compliant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliance(Compliance compliance);
    }

    static final class BuilderImpl implements Builder {
        private String configRuleName;

        private Compliance compliance;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceByConfigRule model) {
            configRuleName(model.configRuleName);
            compliance(model.compliance);
        }

        public final String getConfigRuleName() {
            return configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        public final Compliance.Builder getCompliance() {
            return compliance != null ? compliance.toBuilder() : null;
        }

        @Override
        public final Builder compliance(Compliance compliance) {
            this.compliance = compliance;
            return this;
        }

        public final void setCompliance(Compliance.BuilderImpl compliance) {
            this.compliance = compliance != null ? compliance.build() : null;
        }

        @Override
        public ComplianceByConfigRule build() {
            return new ComplianceByConfigRule(this);
        }
    }
}
