/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.ComplianceByResourceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates whether an AWS resource that is evaluated according to one or more AWS Config rules is compliant. A
 * resource is compliant if it complies with all of the rules that evaluate it, and it is noncompliant if it does not
 * comply with one or more of these rules.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ComplianceByResource implements StructuredPojo,
        ToCopyableBuilder<ComplianceByResource.Builder, ComplianceByResource> {
    private final String resourceType;

    private final String resourceId;

    private final Compliance compliance;

    private ComplianceByResource(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.compliance = builder.compliance;
    }

    /**
     * <p>
     * The type of the AWS resource that was evaluated.
     * </p>
     * 
     * @return The type of the AWS resource that was evaluated.
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The ID of the AWS resource that was evaluated.
     * </p>
     * 
     * @return The ID of the AWS resource that was evaluated.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * Indicates whether the AWS resource complies with all of the AWS Config rules that evaluated it.
     * </p>
     * 
     * @return Indicates whether the AWS resource complies with all of the AWS Config rules that evaluated it.
     */
    public Compliance compliance() {
        return compliance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((resourceType() == null) ? 0 : resourceType().hashCode());
        hashCode = 31 * hashCode + ((resourceId() == null) ? 0 : resourceId().hashCode());
        hashCode = 31 * hashCode + ((compliance() == null) ? 0 : compliance().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceByResource)) {
            return false;
        }
        ComplianceByResource other = (ComplianceByResource) obj;
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.compliance() == null ^ this.compliance() == null) {
            return false;
        }
        if (other.compliance() != null && !other.compliance().equals(this.compliance())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (resourceType() != null) {
            sb.append("ResourceType: ").append(resourceType()).append(",");
        }
        if (resourceId() != null) {
            sb.append("ResourceId: ").append(resourceId()).append(",");
        }
        if (compliance() != null) {
            sb.append("Compliance: ").append(compliance()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceType":
            return Optional.of(clazz.cast(resourceType()));
        case "ResourceId":
            return Optional.of(clazz.cast(resourceId()));
        case "Compliance":
            return Optional.of(clazz.cast(compliance()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComplianceByResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ComplianceByResource> {
        /**
         * <p>
         * The type of the AWS resource that was evaluated.
         * </p>
         * 
         * @param resourceType
         *        The type of the AWS resource that was evaluated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The ID of the AWS resource that was evaluated.
         * </p>
         * 
         * @param resourceId
         *        The ID of the AWS resource that was evaluated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * Indicates whether the AWS resource complies with all of the AWS Config rules that evaluated it.
         * </p>
         * 
         * @param compliance
         *        Indicates whether the AWS resource complies with all of the AWS Config rules that evaluated it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliance(Compliance compliance);
    }

    static final class BuilderImpl implements Builder {
        private String resourceType;

        private String resourceId;

        private Compliance compliance;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceByResource model) {
            resourceType(model.resourceType);
            resourceId(model.resourceId);
            compliance(model.compliance);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Compliance.Builder getCompliance() {
            return compliance != null ? compliance.toBuilder() : null;
        }

        @Override
        public final Builder compliance(Compliance compliance) {
            this.compliance = compliance;
            return this;
        }

        public final void setCompliance(Compliance.BuilderImpl compliance) {
            this.compliance = compliance != null ? compliance.build() : null;
        }

        @Override
        public ComplianceByResource build() {
            return new ComplianceByResource(this);
        }
    }
}
